/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.opsworks.model.CreateDeploymentRequest;
import com.amazonaws.services.opsworks.model.transform.DeploymentCommandJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class CreateDeploymentRequestMarshaller
implements Marshaller<Request<CreateDeploymentRequest>, CreateDeploymentRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateDeploymentRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<CreateDeploymentRequest> marshall(CreateDeploymentRequest createDeploymentRequest) {
        if (createDeploymentRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createDeploymentRequest, "AWSOpsWorks");
        request.addHeader("X-Amz-Target", "OpsWorks_20130218.CreateDeployment");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList layerIdsList;
            SdkInternalList instanceIdsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createDeploymentRequest.getStackId() != null) {
                jsonGenerator.writeFieldName("StackId").writeValue(createDeploymentRequest.getStackId());
            }
            if (createDeploymentRequest.getAppId() != null) {
                jsonGenerator.writeFieldName("AppId").writeValue(createDeploymentRequest.getAppId());
            }
            if (!(instanceIdsList = (SdkInternalList)createDeploymentRequest.getInstanceIds()).isEmpty() || !instanceIdsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("InstanceIds");
                jsonGenerator.writeStartArray();
                for (String instanceIdsListValue : instanceIdsList) {
                    if (instanceIdsListValue == null) continue;
                    jsonGenerator.writeValue(instanceIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(layerIdsList = (SdkInternalList)createDeploymentRequest.getLayerIds()).isEmpty() || !layerIdsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("LayerIds");
                jsonGenerator.writeStartArray();
                for (String layerIdsListValue : layerIdsList) {
                    if (layerIdsListValue == null) continue;
                    jsonGenerator.writeValue(layerIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (createDeploymentRequest.getCommand() != null) {
                jsonGenerator.writeFieldName("Command");
                DeploymentCommandJsonMarshaller.getInstance().marshall(createDeploymentRequest.getCommand(), jsonGenerator);
            }
            if (createDeploymentRequest.getComment() != null) {
                jsonGenerator.writeFieldName("Comment").writeValue(createDeploymentRequest.getComment());
            }
            if (createDeploymentRequest.getCustomJson() != null) {
                jsonGenerator.writeFieldName("CustomJson").writeValue(createDeploymentRequest.getCustomJson());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

