/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.opsworks.model.BlockDeviceMapping;
import com.amazonaws.services.opsworks.model.CreateInstanceRequest;
import com.amazonaws.services.opsworks.model.transform.BlockDeviceMappingJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class CreateInstanceRequestMarshaller
implements Marshaller<Request<CreateInstanceRequest>, CreateInstanceRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateInstanceRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<CreateInstanceRequest> marshall(CreateInstanceRequest createInstanceRequest) {
        if (createInstanceRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createInstanceRequest, "AWSOpsWorks");
        request.addHeader("X-Amz-Target", "OpsWorks_20130218.CreateInstance");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList blockDeviceMappingsList;
            SdkInternalList layerIdsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createInstanceRequest.getStackId() != null) {
                jsonGenerator.writeFieldName("StackId").writeValue(createInstanceRequest.getStackId());
            }
            if (!(layerIdsList = (SdkInternalList)createInstanceRequest.getLayerIds()).isEmpty() || !layerIdsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("LayerIds");
                jsonGenerator.writeStartArray();
                for (String layerIdsListValue : layerIdsList) {
                    if (layerIdsListValue == null) continue;
                    jsonGenerator.writeValue(layerIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (createInstanceRequest.getInstanceType() != null) {
                jsonGenerator.writeFieldName("InstanceType").writeValue(createInstanceRequest.getInstanceType());
            }
            if (createInstanceRequest.getAutoScalingType() != null) {
                jsonGenerator.writeFieldName("AutoScalingType").writeValue(createInstanceRequest.getAutoScalingType());
            }
            if (createInstanceRequest.getHostname() != null) {
                jsonGenerator.writeFieldName("Hostname").writeValue(createInstanceRequest.getHostname());
            }
            if (createInstanceRequest.getOs() != null) {
                jsonGenerator.writeFieldName("Os").writeValue(createInstanceRequest.getOs());
            }
            if (createInstanceRequest.getAmiId() != null) {
                jsonGenerator.writeFieldName("AmiId").writeValue(createInstanceRequest.getAmiId());
            }
            if (createInstanceRequest.getSshKeyName() != null) {
                jsonGenerator.writeFieldName("SshKeyName").writeValue(createInstanceRequest.getSshKeyName());
            }
            if (createInstanceRequest.getAvailabilityZone() != null) {
                jsonGenerator.writeFieldName("AvailabilityZone").writeValue(createInstanceRequest.getAvailabilityZone());
            }
            if (createInstanceRequest.getVirtualizationType() != null) {
                jsonGenerator.writeFieldName("VirtualizationType").writeValue(createInstanceRequest.getVirtualizationType());
            }
            if (createInstanceRequest.getSubnetId() != null) {
                jsonGenerator.writeFieldName("SubnetId").writeValue(createInstanceRequest.getSubnetId());
            }
            if (createInstanceRequest.getArchitecture() != null) {
                jsonGenerator.writeFieldName("Architecture").writeValue(createInstanceRequest.getArchitecture());
            }
            if (createInstanceRequest.getRootDeviceType() != null) {
                jsonGenerator.writeFieldName("RootDeviceType").writeValue(createInstanceRequest.getRootDeviceType());
            }
            if (!(blockDeviceMappingsList = (SdkInternalList)createInstanceRequest.getBlockDeviceMappings()).isEmpty() || !blockDeviceMappingsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("BlockDeviceMappings");
                jsonGenerator.writeStartArray();
                for (BlockDeviceMapping blockDeviceMappingsListValue : blockDeviceMappingsList) {
                    if (blockDeviceMappingsListValue == null) continue;
                    BlockDeviceMappingJsonMarshaller.getInstance().marshall(blockDeviceMappingsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (createInstanceRequest.getInstallUpdatesOnBoot() != null) {
                jsonGenerator.writeFieldName("InstallUpdatesOnBoot").writeValue(createInstanceRequest.getInstallUpdatesOnBoot().booleanValue());
            }
            if (createInstanceRequest.getEbsOptimized() != null) {
                jsonGenerator.writeFieldName("EbsOptimized").writeValue(createInstanceRequest.getEbsOptimized().booleanValue());
            }
            if (createInstanceRequest.getAgentVersion() != null) {
                jsonGenerator.writeFieldName("AgentVersion").writeValue(createInstanceRequest.getAgentVersion());
            }
            if (createInstanceRequest.getTenancy() != null) {
                jsonGenerator.writeFieldName("Tenancy").writeValue(createInstanceRequest.getTenancy());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

