/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.opsworks.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.opsworks.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * Layer JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class LayerJsonUnmarshaller implements Unmarshaller<Layer, JsonUnmarshallerContext> {

    public Layer unmarshall(JsonUnmarshallerContext context) throws Exception {
        Layer layer = new Layer();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        boolean knownMember;

        while (true) {
            if (token == null)
                break;

            knownMember = false;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("Arn", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    layer.setArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("StackId", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    layer.setStackId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("LayerId", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    layer.setLayerId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Type", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    layer.setType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Name", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    layer.setName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Shortname", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    layer.setShortname(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Attributes", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    layer.setAttributes(new MapUnmarshaller<String, String>(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class))
                            .unmarshall(context));
                }
                if (context.testExpression("CloudWatchLogsConfiguration", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    layer.setCloudWatchLogsConfiguration(CloudWatchLogsConfigurationJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("CustomInstanceProfileArn", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    layer.setCustomInstanceProfileArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("CustomJson", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    layer.setCustomJson(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("CustomSecurityGroupIds", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    layer.setCustomSecurityGroupIds(new ListUnmarshaller<String>(context.getUnmarshaller(String.class))

                    .unmarshall(context));
                }
                if (context.testExpression("DefaultSecurityGroupNames", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    layer.setDefaultSecurityGroupNames(new ListUnmarshaller<String>(context.getUnmarshaller(String.class))

                    .unmarshall(context));
                }
                if (context.testExpression("Packages", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    layer.setPackages(new ListUnmarshaller<String>(context.getUnmarshaller(String.class))

                    .unmarshall(context));
                }
                if (context.testExpression("VolumeConfigurations", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    layer.setVolumeConfigurations(new ListUnmarshaller<VolumeConfiguration>(VolumeConfigurationJsonUnmarshaller.getInstance())

                    .unmarshall(context));
                }
                if (context.testExpression("EnableAutoHealing", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    layer.setEnableAutoHealing(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("AutoAssignElasticIps", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    layer.setAutoAssignElasticIps(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("AutoAssignPublicIps", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    layer.setAutoAssignPublicIps(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("DefaultRecipes", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    layer.setDefaultRecipes(RecipesJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("CustomRecipes", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    layer.setCustomRecipes(RecipesJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("CreatedAt", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    layer.setCreatedAt(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("InstallUpdatesOnBoot", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    layer.setInstallUpdatesOnBoot(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("UseEbsOptimizedInstances", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    layer.setUseEbsOptimizedInstances(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("LifecycleEventConfiguration", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    layer.setLifecycleEventConfiguration(LifecycleEventConfigurationJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (token == FIELD_NAME && !knownMember) {
                    context.nextToken();
                    com.amazonaws.transform.UnknownMemberJsonUnmarshaller.getInstance().unmarshall(context);
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return layer;
    }

    private static LayerJsonUnmarshaller instance;

    public static LayerJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new LayerJsonUnmarshaller();
        return instance;
    }
}
