/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.opsworks.model.ChefConfiguration;
import com.amazonaws.services.opsworks.model.CloneStackRequest;
import com.amazonaws.services.opsworks.model.Source;
import com.amazonaws.services.opsworks.model.StackConfigurationManager;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class CloneStackRequestMarshaller
implements Marshaller<Request<CloneStackRequest>, CloneStackRequest> {
    public Request<CloneStackRequest> marshall(CloneStackRequest cloneStackRequest) {
        if (cloneStackRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)cloneStackRequest, "AWSOpsWorks");
        String target = "OpsWorks_20130218.CloneStack";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag cloneAppIdsList;
            Source customCookbooksSource;
            ChefConfiguration chefConfiguration;
            StackConfigurationManager configurationManager;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (cloneStackRequest.getSourceStackId() != null) {
                jsonWriter.key("SourceStackId").value((Object)cloneStackRequest.getSourceStackId());
            }
            if (cloneStackRequest.getName() != null) {
                jsonWriter.key("Name").value((Object)cloneStackRequest.getName());
            }
            if (cloneStackRequest.getRegion() != null) {
                jsonWriter.key("Region").value((Object)cloneStackRequest.getRegion());
            }
            if (cloneStackRequest.getVpcId() != null) {
                jsonWriter.key("VpcId").value((Object)cloneStackRequest.getVpcId());
            }
            if (cloneStackRequest.getAttributes() != null) {
                jsonWriter.key("Attributes");
                jsonWriter.object();
                for (Map.Entry<String, String> attributesListValue : cloneStackRequest.getAttributes().entrySet()) {
                    if (attributesListValue.getValue() == null) continue;
                    jsonWriter.key(attributesListValue.getKey());
                    jsonWriter.value((Object)attributesListValue.getValue());
                }
                jsonWriter.endObject();
            }
            if (cloneStackRequest.getServiceRoleArn() != null) {
                jsonWriter.key("ServiceRoleArn").value((Object)cloneStackRequest.getServiceRoleArn());
            }
            if (cloneStackRequest.getDefaultInstanceProfileArn() != null) {
                jsonWriter.key("DefaultInstanceProfileArn").value((Object)cloneStackRequest.getDefaultInstanceProfileArn());
            }
            if (cloneStackRequest.getDefaultOs() != null) {
                jsonWriter.key("DefaultOs").value((Object)cloneStackRequest.getDefaultOs());
            }
            if (cloneStackRequest.getHostnameTheme() != null) {
                jsonWriter.key("HostnameTheme").value((Object)cloneStackRequest.getHostnameTheme());
            }
            if (cloneStackRequest.getDefaultAvailabilityZone() != null) {
                jsonWriter.key("DefaultAvailabilityZone").value((Object)cloneStackRequest.getDefaultAvailabilityZone());
            }
            if (cloneStackRequest.getDefaultSubnetId() != null) {
                jsonWriter.key("DefaultSubnetId").value((Object)cloneStackRequest.getDefaultSubnetId());
            }
            if (cloneStackRequest.getCustomJson() != null) {
                jsonWriter.key("CustomJson").value((Object)cloneStackRequest.getCustomJson());
            }
            if ((configurationManager = cloneStackRequest.getConfigurationManager()) != null) {
                jsonWriter.key("ConfigurationManager");
                jsonWriter.object();
                if (configurationManager.getName() != null) {
                    jsonWriter.key("Name").value((Object)configurationManager.getName());
                }
                if (configurationManager.getVersion() != null) {
                    jsonWriter.key("Version").value((Object)configurationManager.getVersion());
                }
                jsonWriter.endObject();
            }
            if ((chefConfiguration = cloneStackRequest.getChefConfiguration()) != null) {
                jsonWriter.key("ChefConfiguration");
                jsonWriter.object();
                if (chefConfiguration.isManageBerkshelf() != null) {
                    jsonWriter.key("ManageBerkshelf").value((Object)chefConfiguration.isManageBerkshelf());
                }
                if (chefConfiguration.getBerkshelfVersion() != null) {
                    jsonWriter.key("BerkshelfVersion").value((Object)chefConfiguration.getBerkshelfVersion());
                }
                jsonWriter.endObject();
            }
            if (cloneStackRequest.isUseCustomCookbooks() != null) {
                jsonWriter.key("UseCustomCookbooks").value((Object)cloneStackRequest.isUseCustomCookbooks());
            }
            if (cloneStackRequest.isUseOpsworksSecurityGroups() != null) {
                jsonWriter.key("UseOpsworksSecurityGroups").value((Object)cloneStackRequest.isUseOpsworksSecurityGroups());
            }
            if ((customCookbooksSource = cloneStackRequest.getCustomCookbooksSource()) != null) {
                jsonWriter.key("CustomCookbooksSource");
                jsonWriter.object();
                if (customCookbooksSource.getType() != null) {
                    jsonWriter.key("Type").value((Object)customCookbooksSource.getType());
                }
                if (customCookbooksSource.getUrl() != null) {
                    jsonWriter.key("Url").value((Object)customCookbooksSource.getUrl());
                }
                if (customCookbooksSource.getUsername() != null) {
                    jsonWriter.key("Username").value((Object)customCookbooksSource.getUsername());
                }
                if (customCookbooksSource.getPassword() != null) {
                    jsonWriter.key("Password").value((Object)customCookbooksSource.getPassword());
                }
                if (customCookbooksSource.getSshKey() != null) {
                    jsonWriter.key("SshKey").value((Object)customCookbooksSource.getSshKey());
                }
                if (customCookbooksSource.getRevision() != null) {
                    jsonWriter.key("Revision").value((Object)customCookbooksSource.getRevision());
                }
                jsonWriter.endObject();
            }
            if (cloneStackRequest.getDefaultSshKeyName() != null) {
                jsonWriter.key("DefaultSshKeyName").value((Object)cloneStackRequest.getDefaultSshKeyName());
            }
            if (cloneStackRequest.isClonePermissions() != null) {
                jsonWriter.key("ClonePermissions").value((Object)cloneStackRequest.isClonePermissions());
            }
            if (!((cloneAppIdsList = (ListWithAutoConstructFlag)cloneStackRequest.getCloneAppIds()) == null || cloneAppIdsList.isAutoConstruct() && cloneAppIdsList.isEmpty())) {
                jsonWriter.key("CloneAppIds");
                jsonWriter.array();
                for (String cloneAppIdsListValue : cloneAppIdsList) {
                    if (cloneAppIdsListValue == null) continue;
                    jsonWriter.value((Object)cloneAppIdsListValue);
                }
                jsonWriter.endArray();
            }
            if (cloneStackRequest.getDefaultRootDeviceType() != null) {
                jsonWriter.key("DefaultRootDeviceType").value((Object)cloneStackRequest.getDefaultRootDeviceType());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

