/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.organizations;

import javax.annotation.Generated;

import com.amazonaws.services.organizations.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSOrganizations}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSOrganizations implements AWSOrganizations {

    protected AbstractAWSOrganizations() {
    }

    @Override
    public void setEndpoint(String endpoint) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void setRegion(com.amazonaws.regions.Region region) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AcceptHandshakeResult acceptHandshake(AcceptHandshakeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AttachPolicyResult attachPolicy(AttachPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CancelHandshakeResult cancelHandshake(CancelHandshakeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAccountResult createAccount(CreateAccountRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateOrganizationResult createOrganization(CreateOrganizationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateOrganizationalUnitResult createOrganizationalUnit(CreateOrganizationalUnitRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreatePolicyResult createPolicy(CreatePolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeclineHandshakeResult declineHandshake(DeclineHandshakeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteOrganizationResult deleteOrganization(DeleteOrganizationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteOrganizationalUnitResult deleteOrganizationalUnit(DeleteOrganizationalUnitRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeletePolicyResult deletePolicy(DeletePolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAccountResult describeAccount(DescribeAccountRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeCreateAccountStatusResult describeCreateAccountStatus(DescribeCreateAccountStatusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeHandshakeResult describeHandshake(DescribeHandshakeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeOrganizationResult describeOrganization(DescribeOrganizationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeOrganizationalUnitResult describeOrganizationalUnit(DescribeOrganizationalUnitRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribePolicyResult describePolicy(DescribePolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DetachPolicyResult detachPolicy(DetachPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisableAWSServiceAccessResult disableAWSServiceAccess(DisableAWSServiceAccessRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisablePolicyTypeResult disablePolicyType(DisablePolicyTypeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public EnableAWSServiceAccessResult enableAWSServiceAccess(EnableAWSServiceAccessRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public EnableAllFeaturesResult enableAllFeatures(EnableAllFeaturesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public EnablePolicyTypeResult enablePolicyType(EnablePolicyTypeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public InviteAccountToOrganizationResult inviteAccountToOrganization(InviteAccountToOrganizationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public LeaveOrganizationResult leaveOrganization(LeaveOrganizationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAWSServiceAccessForOrganizationResult listAWSServiceAccessForOrganization(ListAWSServiceAccessForOrganizationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAccountsResult listAccounts(ListAccountsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAccountsForParentResult listAccountsForParent(ListAccountsForParentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListChildrenResult listChildren(ListChildrenRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListCreateAccountStatusResult listCreateAccountStatus(ListCreateAccountStatusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListHandshakesForAccountResult listHandshakesForAccount(ListHandshakesForAccountRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListHandshakesForOrganizationResult listHandshakesForOrganization(ListHandshakesForOrganizationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListOrganizationalUnitsForParentResult listOrganizationalUnitsForParent(ListOrganizationalUnitsForParentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListParentsResult listParents(ListParentsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPoliciesResult listPolicies(ListPoliciesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPoliciesForTargetResult listPoliciesForTarget(ListPoliciesForTargetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListRootsResult listRoots(ListRootsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTargetsForPolicyResult listTargetsForPolicy(ListTargetsForPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public MoveAccountResult moveAccount(MoveAccountRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RemoveAccountFromOrganizationResult removeAccountFromOrganization(RemoveAccountFromOrganizationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateOrganizationalUnitResult updateOrganizationalUnit(UpdateOrganizationalUnitRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdatePolicyResult updatePolicy(UpdatePolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
