/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.osis.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * The destination for OpenSearch Ingestion logs sent to Amazon CloudWatch.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/CloudWatchLogDestination" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CloudWatchLogDestination implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The name of the CloudWatch Logs group to send pipeline logs to. You can specify an existing log group or create a
     * new one. For example, <code>/aws/OpenSearchService/IngestionService/my-pipeline</code>.
     * </p>
     */
    private String logGroup;

    /**
     * <p>
     * The name of the CloudWatch Logs group to send pipeline logs to. You can specify an existing log group or create a
     * new one. For example, <code>/aws/OpenSearchService/IngestionService/my-pipeline</code>.
     * </p>
     * 
     * @param logGroup
     *        The name of the CloudWatch Logs group to send pipeline logs to. You can specify an existing log group or
     *        create a new one. For example, <code>/aws/OpenSearchService/IngestionService/my-pipeline</code>.
     */

    public void setLogGroup(String logGroup) {
        this.logGroup = logGroup;
    }

    /**
     * <p>
     * The name of the CloudWatch Logs group to send pipeline logs to. You can specify an existing log group or create a
     * new one. For example, <code>/aws/OpenSearchService/IngestionService/my-pipeline</code>.
     * </p>
     * 
     * @return The name of the CloudWatch Logs group to send pipeline logs to. You can specify an existing log group or
     *         create a new one. For example, <code>/aws/OpenSearchService/IngestionService/my-pipeline</code>.
     */

    public String getLogGroup() {
        return this.logGroup;
    }

    /**
     * <p>
     * The name of the CloudWatch Logs group to send pipeline logs to. You can specify an existing log group or create a
     * new one. For example, <code>/aws/OpenSearchService/IngestionService/my-pipeline</code>.
     * </p>
     * 
     * @param logGroup
     *        The name of the CloudWatch Logs group to send pipeline logs to. You can specify an existing log group or
     *        create a new one. For example, <code>/aws/OpenSearchService/IngestionService/my-pipeline</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CloudWatchLogDestination withLogGroup(String logGroup) {
        setLogGroup(logGroup);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getLogGroup() != null)
            sb.append("LogGroup: ").append(getLogGroup());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof CloudWatchLogDestination == false)
            return false;
        CloudWatchLogDestination other = (CloudWatchLogDestination) obj;
        if (other.getLogGroup() == null ^ this.getLogGroup() == null)
            return false;
        if (other.getLogGroup() != null && other.getLogGroup().equals(this.getLogGroup()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getLogGroup() == null) ? 0 : getLogGroup().hashCode());
        return hashCode;
    }

    @Override
    public CloudWatchLogDestination clone() {
        try {
            return (CloudWatchLogDestination) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.osis.model.transform.CloudWatchLogDestinationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
