/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.outposts.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.outposts.model.AssetInfo;

@SdkInternalApi
public class AssetInfoMarshaller {
    private static final MarshallingInfo<String> ASSETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AssetId").build();
    private static final MarshallingInfo<String> RACKID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RackId").build();
    private static final MarshallingInfo<String> ASSETTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AssetType").build();
    private static final MarshallingInfo<StructuredPojo> COMPUTEATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComputeAttributes").build();
    private static final MarshallingInfo<StructuredPojo> ASSETLOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AssetLocation").build();
    private static final AssetInfoMarshaller instance = new AssetInfoMarshaller();

    public static AssetInfoMarshaller getInstance() {
        return instance;
    }

    public void marshall(AssetInfo assetInfo, ProtocolMarshaller protocolMarshaller) {
        if (assetInfo == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)assetInfo.getAssetId(), ASSETID_BINDING);
            protocolMarshaller.marshall((Object)assetInfo.getRackId(), RACKID_BINDING);
            protocolMarshaller.marshall((Object)assetInfo.getAssetType(), ASSETTYPE_BINDING);
            protocolMarshaller.marshall((Object)assetInfo.getComputeAttributes(), COMPUTEATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)assetInfo.getAssetLocation(), ASSETLOCATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

