/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.outposts.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.outposts.model.LineItem;
import com.amazonaws.services.outposts.model.OrderStatus;
import com.amazonaws.services.outposts.model.PaymentOption;
import com.amazonaws.services.outposts.model.PaymentTerm;
import com.amazonaws.services.outposts.model.transform.OrderMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Order
implements Serializable,
Cloneable,
StructuredPojo {
    private String outpostId;
    private String orderId;
    private String status;
    private List<LineItem> lineItems;
    private String paymentOption;
    private Date orderSubmissionDate;
    private Date orderFulfilledDate;
    private String paymentTerm;

    public void setOutpostId(String outpostId) {
        this.outpostId = outpostId;
    }

    public String getOutpostId() {
        return this.outpostId;
    }

    public Order withOutpostId(String outpostId) {
        this.setOutpostId(outpostId);
        return this;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public Order withOrderId(String orderId) {
        this.setOrderId(orderId);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public Order withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public Order withStatus(OrderStatus status) {
        this.status = status.toString();
        return this;
    }

    public List<LineItem> getLineItems() {
        return this.lineItems;
    }

    public void setLineItems(Collection<LineItem> lineItems) {
        if (lineItems == null) {
            this.lineItems = null;
            return;
        }
        this.lineItems = new ArrayList<LineItem>(lineItems);
    }

    public Order withLineItems(LineItem ... lineItems) {
        if (this.lineItems == null) {
            this.setLineItems(new ArrayList<LineItem>(lineItems.length));
        }
        for (LineItem ele : lineItems) {
            this.lineItems.add(ele);
        }
        return this;
    }

    public Order withLineItems(Collection<LineItem> lineItems) {
        this.setLineItems(lineItems);
        return this;
    }

    public void setPaymentOption(String paymentOption) {
        this.paymentOption = paymentOption;
    }

    public String getPaymentOption() {
        return this.paymentOption;
    }

    public Order withPaymentOption(String paymentOption) {
        this.setPaymentOption(paymentOption);
        return this;
    }

    public Order withPaymentOption(PaymentOption paymentOption) {
        this.paymentOption = paymentOption.toString();
        return this;
    }

    public void setOrderSubmissionDate(Date orderSubmissionDate) {
        this.orderSubmissionDate = orderSubmissionDate;
    }

    public Date getOrderSubmissionDate() {
        return this.orderSubmissionDate;
    }

    public Order withOrderSubmissionDate(Date orderSubmissionDate) {
        this.setOrderSubmissionDate(orderSubmissionDate);
        return this;
    }

    public void setOrderFulfilledDate(Date orderFulfilledDate) {
        this.orderFulfilledDate = orderFulfilledDate;
    }

    public Date getOrderFulfilledDate() {
        return this.orderFulfilledDate;
    }

    public Order withOrderFulfilledDate(Date orderFulfilledDate) {
        this.setOrderFulfilledDate(orderFulfilledDate);
        return this;
    }

    public void setPaymentTerm(String paymentTerm) {
        this.paymentTerm = paymentTerm;
    }

    public String getPaymentTerm() {
        return this.paymentTerm;
    }

    public Order withPaymentTerm(String paymentTerm) {
        this.setPaymentTerm(paymentTerm);
        return this;
    }

    public Order withPaymentTerm(PaymentTerm paymentTerm) {
        this.paymentTerm = paymentTerm.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getOutpostId() != null) {
            sb.append("OutpostId: ").append(this.getOutpostId()).append(",");
        }
        if (this.getOrderId() != null) {
            sb.append("OrderId: ").append(this.getOrderId()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getLineItems() != null) {
            sb.append("LineItems: ").append(this.getLineItems()).append(",");
        }
        if (this.getPaymentOption() != null) {
            sb.append("PaymentOption: ").append(this.getPaymentOption()).append(",");
        }
        if (this.getOrderSubmissionDate() != null) {
            sb.append("OrderSubmissionDate: ").append(this.getOrderSubmissionDate()).append(",");
        }
        if (this.getOrderFulfilledDate() != null) {
            sb.append("OrderFulfilledDate: ").append(this.getOrderFulfilledDate()).append(",");
        }
        if (this.getPaymentTerm() != null) {
            sb.append("PaymentTerm: ").append(this.getPaymentTerm());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Order)) {
            return false;
        }
        Order other = (Order)obj;
        if (other.getOutpostId() == null ^ this.getOutpostId() == null) {
            return false;
        }
        if (other.getOutpostId() != null && !other.getOutpostId().equals(this.getOutpostId())) {
            return false;
        }
        if (other.getOrderId() == null ^ this.getOrderId() == null) {
            return false;
        }
        if (other.getOrderId() != null && !other.getOrderId().equals(this.getOrderId())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getLineItems() == null ^ this.getLineItems() == null) {
            return false;
        }
        if (other.getLineItems() != null && !other.getLineItems().equals(this.getLineItems())) {
            return false;
        }
        if (other.getPaymentOption() == null ^ this.getPaymentOption() == null) {
            return false;
        }
        if (other.getPaymentOption() != null && !other.getPaymentOption().equals(this.getPaymentOption())) {
            return false;
        }
        if (other.getOrderSubmissionDate() == null ^ this.getOrderSubmissionDate() == null) {
            return false;
        }
        if (other.getOrderSubmissionDate() != null && !other.getOrderSubmissionDate().equals(this.getOrderSubmissionDate())) {
            return false;
        }
        if (other.getOrderFulfilledDate() == null ^ this.getOrderFulfilledDate() == null) {
            return false;
        }
        if (other.getOrderFulfilledDate() != null && !other.getOrderFulfilledDate().equals(this.getOrderFulfilledDate())) {
            return false;
        }
        if (other.getPaymentTerm() == null ^ this.getPaymentTerm() == null) {
            return false;
        }
        return other.getPaymentTerm() == null || other.getPaymentTerm().equals(this.getPaymentTerm());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getOutpostId() == null ? 0 : this.getOutpostId().hashCode());
        hashCode = 31 * hashCode + (this.getOrderId() == null ? 0 : this.getOrderId().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getLineItems() == null ? 0 : this.getLineItems().hashCode());
        hashCode = 31 * hashCode + (this.getPaymentOption() == null ? 0 : this.getPaymentOption().hashCode());
        hashCode = 31 * hashCode + (this.getOrderSubmissionDate() == null ? 0 : this.getOrderSubmissionDate().hashCode());
        hashCode = 31 * hashCode + (this.getOrderFulfilledDate() == null ? 0 : this.getOrderFulfilledDate().hashCode());
        hashCode = 31 * hashCode + (this.getPaymentTerm() == null ? 0 : this.getPaymentTerm().hashCode());
        return hashCode;
    }

    public Order clone() {
        try {
            return (Order)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OrderMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

