/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.outposts.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.outposts.model.CatalogItemStatus;
import com.amazonaws.services.outposts.model.EC2Capacity;
import com.amazonaws.services.outposts.model.SupportedStorageEnum;
import com.amazonaws.services.outposts.model.transform.CatalogItemMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CatalogItem
implements Serializable,
Cloneable,
StructuredPojo {
    private String catalogItemId;
    private String itemStatus;
    private List<EC2Capacity> eC2Capacities;
    private Float powerKva;
    private Integer weightLbs;
    private List<Integer> supportedUplinkGbps;
    private List<String> supportedStorage;

    public void setCatalogItemId(String catalogItemId) {
        this.catalogItemId = catalogItemId;
    }

    public String getCatalogItemId() {
        return this.catalogItemId;
    }

    public CatalogItem withCatalogItemId(String catalogItemId) {
        this.setCatalogItemId(catalogItemId);
        return this;
    }

    public void setItemStatus(String itemStatus) {
        this.itemStatus = itemStatus;
    }

    public String getItemStatus() {
        return this.itemStatus;
    }

    public CatalogItem withItemStatus(String itemStatus) {
        this.setItemStatus(itemStatus);
        return this;
    }

    public CatalogItem withItemStatus(CatalogItemStatus itemStatus) {
        this.itemStatus = itemStatus.toString();
        return this;
    }

    public List<EC2Capacity> getEC2Capacities() {
        return this.eC2Capacities;
    }

    public void setEC2Capacities(Collection<EC2Capacity> eC2Capacities) {
        if (eC2Capacities == null) {
            this.eC2Capacities = null;
            return;
        }
        this.eC2Capacities = new ArrayList<EC2Capacity>(eC2Capacities);
    }

    public CatalogItem withEC2Capacities(EC2Capacity ... eC2Capacities) {
        if (this.eC2Capacities == null) {
            this.setEC2Capacities(new ArrayList<EC2Capacity>(eC2Capacities.length));
        }
        for (EC2Capacity ele : eC2Capacities) {
            this.eC2Capacities.add(ele);
        }
        return this;
    }

    public CatalogItem withEC2Capacities(Collection<EC2Capacity> eC2Capacities) {
        this.setEC2Capacities(eC2Capacities);
        return this;
    }

    public void setPowerKva(Float powerKva) {
        this.powerKva = powerKva;
    }

    public Float getPowerKva() {
        return this.powerKva;
    }

    public CatalogItem withPowerKva(Float powerKva) {
        this.setPowerKva(powerKva);
        return this;
    }

    public void setWeightLbs(Integer weightLbs) {
        this.weightLbs = weightLbs;
    }

    public Integer getWeightLbs() {
        return this.weightLbs;
    }

    public CatalogItem withWeightLbs(Integer weightLbs) {
        this.setWeightLbs(weightLbs);
        return this;
    }

    public List<Integer> getSupportedUplinkGbps() {
        return this.supportedUplinkGbps;
    }

    public void setSupportedUplinkGbps(Collection<Integer> supportedUplinkGbps) {
        if (supportedUplinkGbps == null) {
            this.supportedUplinkGbps = null;
            return;
        }
        this.supportedUplinkGbps = new ArrayList<Integer>(supportedUplinkGbps);
    }

    public CatalogItem withSupportedUplinkGbps(Integer ... supportedUplinkGbps) {
        if (this.supportedUplinkGbps == null) {
            this.setSupportedUplinkGbps(new ArrayList<Integer>(supportedUplinkGbps.length));
        }
        for (Integer ele : supportedUplinkGbps) {
            this.supportedUplinkGbps.add(ele);
        }
        return this;
    }

    public CatalogItem withSupportedUplinkGbps(Collection<Integer> supportedUplinkGbps) {
        this.setSupportedUplinkGbps(supportedUplinkGbps);
        return this;
    }

    public List<String> getSupportedStorage() {
        return this.supportedStorage;
    }

    public void setSupportedStorage(Collection<String> supportedStorage) {
        if (supportedStorage == null) {
            this.supportedStorage = null;
            return;
        }
        this.supportedStorage = new ArrayList<String>(supportedStorage);
    }

    public CatalogItem withSupportedStorage(String ... supportedStorage) {
        if (this.supportedStorage == null) {
            this.setSupportedStorage(new ArrayList<String>(supportedStorage.length));
        }
        for (String ele : supportedStorage) {
            this.supportedStorage.add(ele);
        }
        return this;
    }

    public CatalogItem withSupportedStorage(Collection<String> supportedStorage) {
        this.setSupportedStorage(supportedStorage);
        return this;
    }

    public CatalogItem withSupportedStorage(SupportedStorageEnum ... supportedStorage) {
        ArrayList<String> supportedStorageCopy = new ArrayList<String>(supportedStorage.length);
        for (SupportedStorageEnum value : supportedStorage) {
            supportedStorageCopy.add(value.toString());
        }
        if (this.getSupportedStorage() == null) {
            this.setSupportedStorage(supportedStorageCopy);
        } else {
            this.getSupportedStorage().addAll(supportedStorageCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCatalogItemId() != null) {
            sb.append("CatalogItemId: ").append(this.getCatalogItemId()).append(",");
        }
        if (this.getItemStatus() != null) {
            sb.append("ItemStatus: ").append(this.getItemStatus()).append(",");
        }
        if (this.getEC2Capacities() != null) {
            sb.append("EC2Capacities: ").append(this.getEC2Capacities()).append(",");
        }
        if (this.getPowerKva() != null) {
            sb.append("PowerKva: ").append(this.getPowerKva()).append(",");
        }
        if (this.getWeightLbs() != null) {
            sb.append("WeightLbs: ").append(this.getWeightLbs()).append(",");
        }
        if (this.getSupportedUplinkGbps() != null) {
            sb.append("SupportedUplinkGbps: ").append(this.getSupportedUplinkGbps()).append(",");
        }
        if (this.getSupportedStorage() != null) {
            sb.append("SupportedStorage: ").append(this.getSupportedStorage());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CatalogItem)) {
            return false;
        }
        CatalogItem other = (CatalogItem)obj;
        if (other.getCatalogItemId() == null ^ this.getCatalogItemId() == null) {
            return false;
        }
        if (other.getCatalogItemId() != null && !other.getCatalogItemId().equals(this.getCatalogItemId())) {
            return false;
        }
        if (other.getItemStatus() == null ^ this.getItemStatus() == null) {
            return false;
        }
        if (other.getItemStatus() != null && !other.getItemStatus().equals(this.getItemStatus())) {
            return false;
        }
        if (other.getEC2Capacities() == null ^ this.getEC2Capacities() == null) {
            return false;
        }
        if (other.getEC2Capacities() != null && !other.getEC2Capacities().equals(this.getEC2Capacities())) {
            return false;
        }
        if (other.getPowerKva() == null ^ this.getPowerKva() == null) {
            return false;
        }
        if (other.getPowerKva() != null && !other.getPowerKva().equals(this.getPowerKva())) {
            return false;
        }
        if (other.getWeightLbs() == null ^ this.getWeightLbs() == null) {
            return false;
        }
        if (other.getWeightLbs() != null && !other.getWeightLbs().equals(this.getWeightLbs())) {
            return false;
        }
        if (other.getSupportedUplinkGbps() == null ^ this.getSupportedUplinkGbps() == null) {
            return false;
        }
        if (other.getSupportedUplinkGbps() != null && !other.getSupportedUplinkGbps().equals(this.getSupportedUplinkGbps())) {
            return false;
        }
        if (other.getSupportedStorage() == null ^ this.getSupportedStorage() == null) {
            return false;
        }
        return other.getSupportedStorage() == null || other.getSupportedStorage().equals(this.getSupportedStorage());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCatalogItemId() == null ? 0 : this.getCatalogItemId().hashCode());
        hashCode = 31 * hashCode + (this.getItemStatus() == null ? 0 : this.getItemStatus().hashCode());
        hashCode = 31 * hashCode + (this.getEC2Capacities() == null ? 0 : this.getEC2Capacities().hashCode());
        hashCode = 31 * hashCode + (this.getPowerKva() == null ? 0 : this.getPowerKva().hashCode());
        hashCode = 31 * hashCode + (this.getWeightLbs() == null ? 0 : this.getWeightLbs().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedUplinkGbps() == null ? 0 : this.getSupportedUplinkGbps().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedStorage() == null ? 0 : this.getSupportedStorage().hashCode());
        return hashCode;
    }

    public CatalogItem clone() {
        try {
            return (CatalogItem)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CatalogItemMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

