/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.outposts.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.outposts.model.ShipmentInformation;

@SdkInternalApi
public class ShipmentInformationMarshaller {
    private static final MarshallingInfo<String> SHIPMENTTRACKINGNUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ShipmentTrackingNumber").build();
    private static final MarshallingInfo<String> SHIPMENTCARRIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ShipmentCarrier").build();
    private static final ShipmentInformationMarshaller instance = new ShipmentInformationMarshaller();

    public static ShipmentInformationMarshaller getInstance() {
        return instance;
    }

    public void marshall(ShipmentInformation shipmentInformation, ProtocolMarshaller protocolMarshaller) {
        if (shipmentInformation == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)shipmentInformation.getShipmentTrackingNumber(), SHIPMENTTRACKINGNUMBER_BINDING);
            protocolMarshaller.marshall((Object)shipmentInformation.getShipmentCarrier(), SHIPMENTCARRIER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

