/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.outposts.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Information about an instance type.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/InstanceTypeItem" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class InstanceTypeItem implements Serializable, Cloneable, StructuredPojo {

    private String instanceType;
    /**
     * <p>
     * The number of default VCPUs in an instance type.
     * </p>
     */
    private Integer vCPUs;

    /**
     * @param instanceType
     */

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    /**
     * @return
     */

    public String getInstanceType() {
        return this.instanceType;
    }

    /**
     * @param instanceType
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public InstanceTypeItem withInstanceType(String instanceType) {
        setInstanceType(instanceType);
        return this;
    }

    /**
     * <p>
     * The number of default VCPUs in an instance type.
     * </p>
     * 
     * @param vCPUs
     *        The number of default VCPUs in an instance type.
     */

    public void setVCPUs(Integer vCPUs) {
        this.vCPUs = vCPUs;
    }

    /**
     * <p>
     * The number of default VCPUs in an instance type.
     * </p>
     * 
     * @return The number of default VCPUs in an instance type.
     */

    public Integer getVCPUs() {
        return this.vCPUs;
    }

    /**
     * <p>
     * The number of default VCPUs in an instance type.
     * </p>
     * 
     * @param vCPUs
     *        The number of default VCPUs in an instance type.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public InstanceTypeItem withVCPUs(Integer vCPUs) {
        setVCPUs(vCPUs);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getInstanceType() != null)
            sb.append("InstanceType: ").append(getInstanceType()).append(",");
        if (getVCPUs() != null)
            sb.append("VCPUs: ").append(getVCPUs());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof InstanceTypeItem == false)
            return false;
        InstanceTypeItem other = (InstanceTypeItem) obj;
        if (other.getInstanceType() == null ^ this.getInstanceType() == null)
            return false;
        if (other.getInstanceType() != null && other.getInstanceType().equals(this.getInstanceType()) == false)
            return false;
        if (other.getVCPUs() == null ^ this.getVCPUs() == null)
            return false;
        if (other.getVCPUs() != null && other.getVCPUs().equals(this.getVCPUs()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getInstanceType() == null) ? 0 : getInstanceType().hashCode());
        hashCode = prime * hashCode + ((getVCPUs() == null) ? 0 : getVCPUs().hashCode());
        return hashCode;
    }

    @Override
    public InstanceTypeItem clone() {
        try {
            return (InstanceTypeItem) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.outposts.model.transform.InstanceTypeItemMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
