/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.paymentcryptography.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.paymentcryptography.model.ImportKeyMaterial;
import com.amazonaws.services.paymentcryptography.model.KeyCheckValueAlgorithm;
import com.amazonaws.services.paymentcryptography.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ImportKeyRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private Boolean enabled;
    private String keyCheckValueAlgorithm;
    private ImportKeyMaterial keyMaterial;
    private List<Tag> tags;

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public ImportKeyRequest withEnabled(Boolean enabled) {
        this.setEnabled(enabled);
        return this;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setKeyCheckValueAlgorithm(String keyCheckValueAlgorithm) {
        this.keyCheckValueAlgorithm = keyCheckValueAlgorithm;
    }

    public String getKeyCheckValueAlgorithm() {
        return this.keyCheckValueAlgorithm;
    }

    public ImportKeyRequest withKeyCheckValueAlgorithm(String keyCheckValueAlgorithm) {
        this.setKeyCheckValueAlgorithm(keyCheckValueAlgorithm);
        return this;
    }

    public ImportKeyRequest withKeyCheckValueAlgorithm(KeyCheckValueAlgorithm keyCheckValueAlgorithm) {
        this.keyCheckValueAlgorithm = keyCheckValueAlgorithm.toString();
        return this;
    }

    public void setKeyMaterial(ImportKeyMaterial keyMaterial) {
        this.keyMaterial = keyMaterial;
    }

    public ImportKeyMaterial getKeyMaterial() {
        return this.keyMaterial;
    }

    public ImportKeyRequest withKeyMaterial(ImportKeyMaterial keyMaterial) {
        this.setKeyMaterial(keyMaterial);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public ImportKeyRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public ImportKeyRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEnabled() != null) {
            sb.append("Enabled: ").append(this.getEnabled()).append(",");
        }
        if (this.getKeyCheckValueAlgorithm() != null) {
            sb.append("KeyCheckValueAlgorithm: ").append(this.getKeyCheckValueAlgorithm()).append(",");
        }
        if (this.getKeyMaterial() != null) {
            sb.append("KeyMaterial: ").append(this.getKeyMaterial()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportKeyRequest)) {
            return false;
        }
        ImportKeyRequest other = (ImportKeyRequest)obj;
        if (other.getEnabled() == null ^ this.getEnabled() == null) {
            return false;
        }
        if (other.getEnabled() != null && !other.getEnabled().equals(this.getEnabled())) {
            return false;
        }
        if (other.getKeyCheckValueAlgorithm() == null ^ this.getKeyCheckValueAlgorithm() == null) {
            return false;
        }
        if (other.getKeyCheckValueAlgorithm() != null && !other.getKeyCheckValueAlgorithm().equals(this.getKeyCheckValueAlgorithm())) {
            return false;
        }
        if (other.getKeyMaterial() == null ^ this.getKeyMaterial() == null) {
            return false;
        }
        if (other.getKeyMaterial() != null && !other.getKeyMaterial().equals(this.getKeyMaterial())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEnabled() == null ? 0 : this.getEnabled().hashCode());
        hashCode = 31 * hashCode + (this.getKeyCheckValueAlgorithm() == null ? 0 : this.getKeyCheckValueAlgorithm().hashCode());
        hashCode = 31 * hashCode + (this.getKeyMaterial() == null ? 0 : this.getKeyMaterial().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public ImportKeyRequest clone() {
        return (ImportKeyRequest)super.clone();
    }
}

