/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.paymentcryptography.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.paymentcryptography.model.KeyBlockHeaders;
import com.amazonaws.services.paymentcryptography.model.Tr34KeyBlockFormat;
import com.amazonaws.services.paymentcryptography.model.transform.ExportTr34KeyBlockMarshaller;
import java.io.Serializable;

public class ExportTr34KeyBlock
implements Serializable,
Cloneable,
StructuredPojo {
    private String certificateAuthorityPublicKeyIdentifier;
    private String wrappingKeyCertificate;
    private String exportToken;
    private String keyBlockFormat;
    private String randomNonce;
    private KeyBlockHeaders keyBlockHeaders;

    public void setCertificateAuthorityPublicKeyIdentifier(String certificateAuthorityPublicKeyIdentifier) {
        this.certificateAuthorityPublicKeyIdentifier = certificateAuthorityPublicKeyIdentifier;
    }

    public String getCertificateAuthorityPublicKeyIdentifier() {
        return this.certificateAuthorityPublicKeyIdentifier;
    }

    public ExportTr34KeyBlock withCertificateAuthorityPublicKeyIdentifier(String certificateAuthorityPublicKeyIdentifier) {
        this.setCertificateAuthorityPublicKeyIdentifier(certificateAuthorityPublicKeyIdentifier);
        return this;
    }

    public void setWrappingKeyCertificate(String wrappingKeyCertificate) {
        this.wrappingKeyCertificate = wrappingKeyCertificate;
    }

    public String getWrappingKeyCertificate() {
        return this.wrappingKeyCertificate;
    }

    public ExportTr34KeyBlock withWrappingKeyCertificate(String wrappingKeyCertificate) {
        this.setWrappingKeyCertificate(wrappingKeyCertificate);
        return this;
    }

    public void setExportToken(String exportToken) {
        this.exportToken = exportToken;
    }

    public String getExportToken() {
        return this.exportToken;
    }

    public ExportTr34KeyBlock withExportToken(String exportToken) {
        this.setExportToken(exportToken);
        return this;
    }

    public void setKeyBlockFormat(String keyBlockFormat) {
        this.keyBlockFormat = keyBlockFormat;
    }

    public String getKeyBlockFormat() {
        return this.keyBlockFormat;
    }

    public ExportTr34KeyBlock withKeyBlockFormat(String keyBlockFormat) {
        this.setKeyBlockFormat(keyBlockFormat);
        return this;
    }

    public ExportTr34KeyBlock withKeyBlockFormat(Tr34KeyBlockFormat keyBlockFormat) {
        this.keyBlockFormat = keyBlockFormat.toString();
        return this;
    }

    public void setRandomNonce(String randomNonce) {
        this.randomNonce = randomNonce;
    }

    public String getRandomNonce() {
        return this.randomNonce;
    }

    public ExportTr34KeyBlock withRandomNonce(String randomNonce) {
        this.setRandomNonce(randomNonce);
        return this;
    }

    public void setKeyBlockHeaders(KeyBlockHeaders keyBlockHeaders) {
        this.keyBlockHeaders = keyBlockHeaders;
    }

    public KeyBlockHeaders getKeyBlockHeaders() {
        return this.keyBlockHeaders;
    }

    public ExportTr34KeyBlock withKeyBlockHeaders(KeyBlockHeaders keyBlockHeaders) {
        this.setKeyBlockHeaders(keyBlockHeaders);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCertificateAuthorityPublicKeyIdentifier() != null) {
            sb.append("CertificateAuthorityPublicKeyIdentifier: ").append(this.getCertificateAuthorityPublicKeyIdentifier()).append(",");
        }
        if (this.getWrappingKeyCertificate() != null) {
            sb.append("WrappingKeyCertificate: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getExportToken() != null) {
            sb.append("ExportToken: ").append(this.getExportToken()).append(",");
        }
        if (this.getKeyBlockFormat() != null) {
            sb.append("KeyBlockFormat: ").append(this.getKeyBlockFormat()).append(",");
        }
        if (this.getRandomNonce() != null) {
            sb.append("RandomNonce: ").append(this.getRandomNonce()).append(",");
        }
        if (this.getKeyBlockHeaders() != null) {
            sb.append("KeyBlockHeaders: ").append(this.getKeyBlockHeaders());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportTr34KeyBlock)) {
            return false;
        }
        ExportTr34KeyBlock other = (ExportTr34KeyBlock)obj;
        if (other.getCertificateAuthorityPublicKeyIdentifier() == null ^ this.getCertificateAuthorityPublicKeyIdentifier() == null) {
            return false;
        }
        if (other.getCertificateAuthorityPublicKeyIdentifier() != null && !other.getCertificateAuthorityPublicKeyIdentifier().equals(this.getCertificateAuthorityPublicKeyIdentifier())) {
            return false;
        }
        if (other.getWrappingKeyCertificate() == null ^ this.getWrappingKeyCertificate() == null) {
            return false;
        }
        if (other.getWrappingKeyCertificate() != null && !other.getWrappingKeyCertificate().equals(this.getWrappingKeyCertificate())) {
            return false;
        }
        if (other.getExportToken() == null ^ this.getExportToken() == null) {
            return false;
        }
        if (other.getExportToken() != null && !other.getExportToken().equals(this.getExportToken())) {
            return false;
        }
        if (other.getKeyBlockFormat() == null ^ this.getKeyBlockFormat() == null) {
            return false;
        }
        if (other.getKeyBlockFormat() != null && !other.getKeyBlockFormat().equals(this.getKeyBlockFormat())) {
            return false;
        }
        if (other.getRandomNonce() == null ^ this.getRandomNonce() == null) {
            return false;
        }
        if (other.getRandomNonce() != null && !other.getRandomNonce().equals(this.getRandomNonce())) {
            return false;
        }
        if (other.getKeyBlockHeaders() == null ^ this.getKeyBlockHeaders() == null) {
            return false;
        }
        return other.getKeyBlockHeaders() == null || other.getKeyBlockHeaders().equals(this.getKeyBlockHeaders());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCertificateAuthorityPublicKeyIdentifier() == null ? 0 : this.getCertificateAuthorityPublicKeyIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getWrappingKeyCertificate() == null ? 0 : this.getWrappingKeyCertificate().hashCode());
        hashCode = 31 * hashCode + (this.getExportToken() == null ? 0 : this.getExportToken().hashCode());
        hashCode = 31 * hashCode + (this.getKeyBlockFormat() == null ? 0 : this.getKeyBlockFormat().hashCode());
        hashCode = 31 * hashCode + (this.getRandomNonce() == null ? 0 : this.getRandomNonce().hashCode());
        hashCode = 31 * hashCode + (this.getKeyBlockHeaders() == null ? 0 : this.getKeyBlockHeaders().hashCode());
        return hashCode;
    }

    public ExportTr34KeyBlock clone() {
        try {
            return (ExportTr34KeyBlock)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ExportTr34KeyBlockMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

