/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.paymentcryptographydata.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Parameters that are required to generate or verify dCVC (Dynamic Card Verification Code).
 * </p>
 * 
 * @see <a
 *      href="http://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-data-2022-02-03/DiscoverDynamicCardVerificationCode"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DiscoverDynamicCardVerificationCode implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The expiry date of a payment card.
     * </p>
     */
    private String cardExpiryDate;
    /**
     * <p>
     * A random number that is generated by the issuer.
     * </p>
     */
    private String unpredictableNumber;
    /**
     * <p>
     * The transaction counter value that comes from the terminal.
     * </p>
     */
    private String applicationTransactionCounter;

    /**
     * <p>
     * The expiry date of a payment card.
     * </p>
     * 
     * @param cardExpiryDate
     *        The expiry date of a payment card.
     */

    public void setCardExpiryDate(String cardExpiryDate) {
        this.cardExpiryDate = cardExpiryDate;
    }

    /**
     * <p>
     * The expiry date of a payment card.
     * </p>
     * 
     * @return The expiry date of a payment card.
     */

    public String getCardExpiryDate() {
        return this.cardExpiryDate;
    }

    /**
     * <p>
     * The expiry date of a payment card.
     * </p>
     * 
     * @param cardExpiryDate
     *        The expiry date of a payment card.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DiscoverDynamicCardVerificationCode withCardExpiryDate(String cardExpiryDate) {
        setCardExpiryDate(cardExpiryDate);
        return this;
    }

    /**
     * <p>
     * A random number that is generated by the issuer.
     * </p>
     * 
     * @param unpredictableNumber
     *        A random number that is generated by the issuer.
     */

    public void setUnpredictableNumber(String unpredictableNumber) {
        this.unpredictableNumber = unpredictableNumber;
    }

    /**
     * <p>
     * A random number that is generated by the issuer.
     * </p>
     * 
     * @return A random number that is generated by the issuer.
     */

    public String getUnpredictableNumber() {
        return this.unpredictableNumber;
    }

    /**
     * <p>
     * A random number that is generated by the issuer.
     * </p>
     * 
     * @param unpredictableNumber
     *        A random number that is generated by the issuer.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DiscoverDynamicCardVerificationCode withUnpredictableNumber(String unpredictableNumber) {
        setUnpredictableNumber(unpredictableNumber);
        return this;
    }

    /**
     * <p>
     * The transaction counter value that comes from the terminal.
     * </p>
     * 
     * @param applicationTransactionCounter
     *        The transaction counter value that comes from the terminal.
     */

    public void setApplicationTransactionCounter(String applicationTransactionCounter) {
        this.applicationTransactionCounter = applicationTransactionCounter;
    }

    /**
     * <p>
     * The transaction counter value that comes from the terminal.
     * </p>
     * 
     * @return The transaction counter value that comes from the terminal.
     */

    public String getApplicationTransactionCounter() {
        return this.applicationTransactionCounter;
    }

    /**
     * <p>
     * The transaction counter value that comes from the terminal.
     * </p>
     * 
     * @param applicationTransactionCounter
     *        The transaction counter value that comes from the terminal.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DiscoverDynamicCardVerificationCode withApplicationTransactionCounter(String applicationTransactionCounter) {
        setApplicationTransactionCounter(applicationTransactionCounter);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getCardExpiryDate() != null)
            sb.append("CardExpiryDate: ").append(getCardExpiryDate()).append(",");
        if (getUnpredictableNumber() != null)
            sb.append("UnpredictableNumber: ").append(getUnpredictableNumber()).append(",");
        if (getApplicationTransactionCounter() != null)
            sb.append("ApplicationTransactionCounter: ").append(getApplicationTransactionCounter());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DiscoverDynamicCardVerificationCode == false)
            return false;
        DiscoverDynamicCardVerificationCode other = (DiscoverDynamicCardVerificationCode) obj;
        if (other.getCardExpiryDate() == null ^ this.getCardExpiryDate() == null)
            return false;
        if (other.getCardExpiryDate() != null && other.getCardExpiryDate().equals(this.getCardExpiryDate()) == false)
            return false;
        if (other.getUnpredictableNumber() == null ^ this.getUnpredictableNumber() == null)
            return false;
        if (other.getUnpredictableNumber() != null && other.getUnpredictableNumber().equals(this.getUnpredictableNumber()) == false)
            return false;
        if (other.getApplicationTransactionCounter() == null ^ this.getApplicationTransactionCounter() == null)
            return false;
        if (other.getApplicationTransactionCounter() != null
                && other.getApplicationTransactionCounter().equals(this.getApplicationTransactionCounter()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getCardExpiryDate() == null) ? 0 : getCardExpiryDate().hashCode());
        hashCode = prime * hashCode + ((getUnpredictableNumber() == null) ? 0 : getUnpredictableNumber().hashCode());
        hashCode = prime * hashCode + ((getApplicationTransactionCounter() == null) ? 0 : getApplicationTransactionCounter().hashCode());
        return hashCode;
    }

    @Override
    public DiscoverDynamicCardVerificationCode clone() {
        try {
            return (DiscoverDynamicCardVerificationCode) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.paymentcryptographydata.model.transform.DiscoverDynamicCardVerificationCodeMarshaller.getInstance().marshall(this,
                protocolMarshaller);
    }
}
