/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.paymentcryptographydata.model.transform;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.paymentcryptographydata.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * VerifyAuthRequestCryptogramRequestMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class VerifyAuthRequestCryptogramRequestMarshaller {

    private static final MarshallingInfo<String> KEYIDENTIFIER_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyIdentifier").build();
    private static final MarshallingInfo<String> TRANSACTIONDATA_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TransactionData").build();
    private static final MarshallingInfo<String> AUTHREQUESTCRYPTOGRAM_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AuthRequestCryptogram").build();
    private static final MarshallingInfo<String> MAJORKEYDERIVATIONMODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MajorKeyDerivationMode").build();
    private static final MarshallingInfo<StructuredPojo> SESSIONKEYDERIVATIONATTRIBUTES_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SessionKeyDerivationAttributes").build();
    private static final MarshallingInfo<StructuredPojo> AUTHRESPONSEATTRIBUTES_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AuthResponseAttributes").build();

    private static final VerifyAuthRequestCryptogramRequestMarshaller instance = new VerifyAuthRequestCryptogramRequestMarshaller();

    public static VerifyAuthRequestCryptogramRequestMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(VerifyAuthRequestCryptogramRequest verifyAuthRequestCryptogramRequest, ProtocolMarshaller protocolMarshaller) {

        if (verifyAuthRequestCryptogramRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(verifyAuthRequestCryptogramRequest.getKeyIdentifier(), KEYIDENTIFIER_BINDING);
            protocolMarshaller.marshall(verifyAuthRequestCryptogramRequest.getTransactionData(), TRANSACTIONDATA_BINDING);
            protocolMarshaller.marshall(verifyAuthRequestCryptogramRequest.getAuthRequestCryptogram(), AUTHREQUESTCRYPTOGRAM_BINDING);
            protocolMarshaller.marshall(verifyAuthRequestCryptogramRequest.getMajorKeyDerivationMode(), MAJORKEYDERIVATIONMODE_BINDING);
            protocolMarshaller.marshall(verifyAuthRequestCryptogramRequest.getSessionKeyDerivationAttributes(), SESSIONKEYDERIVATIONATTRIBUTES_BINDING);
            protocolMarshaller.marshall(verifyAuthRequestCryptogramRequest.getAuthResponseAttributes(), AUTHRESPONSEATTRIBUTES_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
