/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.personalize.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.personalize.model.AutoMLConfig;
import com.amazonaws.services.personalize.model.HPOConfig;
import com.amazonaws.services.personalize.model.transform.SolutionConfigMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class SolutionConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String eventValueThreshold;
    private HPOConfig hpoConfig;
    private Map<String, String> algorithmHyperParameters;
    private Map<String, String> featureTransformationParameters;
    private AutoMLConfig autoMLConfig;

    public void setEventValueThreshold(String eventValueThreshold) {
        this.eventValueThreshold = eventValueThreshold;
    }

    public String getEventValueThreshold() {
        return this.eventValueThreshold;
    }

    public SolutionConfig withEventValueThreshold(String eventValueThreshold) {
        this.setEventValueThreshold(eventValueThreshold);
        return this;
    }

    public void setHpoConfig(HPOConfig hpoConfig) {
        this.hpoConfig = hpoConfig;
    }

    public HPOConfig getHpoConfig() {
        return this.hpoConfig;
    }

    public SolutionConfig withHpoConfig(HPOConfig hpoConfig) {
        this.setHpoConfig(hpoConfig);
        return this;
    }

    public Map<String, String> getAlgorithmHyperParameters() {
        return this.algorithmHyperParameters;
    }

    public void setAlgorithmHyperParameters(Map<String, String> algorithmHyperParameters) {
        this.algorithmHyperParameters = algorithmHyperParameters;
    }

    public SolutionConfig withAlgorithmHyperParameters(Map<String, String> algorithmHyperParameters) {
        this.setAlgorithmHyperParameters(algorithmHyperParameters);
        return this;
    }

    public SolutionConfig addAlgorithmHyperParametersEntry(String key, String value) {
        if (null == this.algorithmHyperParameters) {
            this.algorithmHyperParameters = new HashMap<String, String>();
        }
        if (this.algorithmHyperParameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.algorithmHyperParameters.put(key, value);
        return this;
    }

    public SolutionConfig clearAlgorithmHyperParametersEntries() {
        this.algorithmHyperParameters = null;
        return this;
    }

    public Map<String, String> getFeatureTransformationParameters() {
        return this.featureTransformationParameters;
    }

    public void setFeatureTransformationParameters(Map<String, String> featureTransformationParameters) {
        this.featureTransformationParameters = featureTransformationParameters;
    }

    public SolutionConfig withFeatureTransformationParameters(Map<String, String> featureTransformationParameters) {
        this.setFeatureTransformationParameters(featureTransformationParameters);
        return this;
    }

    public SolutionConfig addFeatureTransformationParametersEntry(String key, String value) {
        if (null == this.featureTransformationParameters) {
            this.featureTransformationParameters = new HashMap<String, String>();
        }
        if (this.featureTransformationParameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.featureTransformationParameters.put(key, value);
        return this;
    }

    public SolutionConfig clearFeatureTransformationParametersEntries() {
        this.featureTransformationParameters = null;
        return this;
    }

    public void setAutoMLConfig(AutoMLConfig autoMLConfig) {
        this.autoMLConfig = autoMLConfig;
    }

    public AutoMLConfig getAutoMLConfig() {
        return this.autoMLConfig;
    }

    public SolutionConfig withAutoMLConfig(AutoMLConfig autoMLConfig) {
        this.setAutoMLConfig(autoMLConfig);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEventValueThreshold() != null) {
            sb.append("EventValueThreshold: ").append(this.getEventValueThreshold()).append(",");
        }
        if (this.getHpoConfig() != null) {
            sb.append("HpoConfig: ").append(this.getHpoConfig()).append(",");
        }
        if (this.getAlgorithmHyperParameters() != null) {
            sb.append("AlgorithmHyperParameters: ").append(this.getAlgorithmHyperParameters()).append(",");
        }
        if (this.getFeatureTransformationParameters() != null) {
            sb.append("FeatureTransformationParameters: ").append(this.getFeatureTransformationParameters()).append(",");
        }
        if (this.getAutoMLConfig() != null) {
            sb.append("AutoMLConfig: ").append(this.getAutoMLConfig());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SolutionConfig)) {
            return false;
        }
        SolutionConfig other = (SolutionConfig)obj;
        if (other.getEventValueThreshold() == null ^ this.getEventValueThreshold() == null) {
            return false;
        }
        if (other.getEventValueThreshold() != null && !other.getEventValueThreshold().equals(this.getEventValueThreshold())) {
            return false;
        }
        if (other.getHpoConfig() == null ^ this.getHpoConfig() == null) {
            return false;
        }
        if (other.getHpoConfig() != null && !other.getHpoConfig().equals(this.getHpoConfig())) {
            return false;
        }
        if (other.getAlgorithmHyperParameters() == null ^ this.getAlgorithmHyperParameters() == null) {
            return false;
        }
        if (other.getAlgorithmHyperParameters() != null && !other.getAlgorithmHyperParameters().equals(this.getAlgorithmHyperParameters())) {
            return false;
        }
        if (other.getFeatureTransformationParameters() == null ^ this.getFeatureTransformationParameters() == null) {
            return false;
        }
        if (other.getFeatureTransformationParameters() != null && !other.getFeatureTransformationParameters().equals(this.getFeatureTransformationParameters())) {
            return false;
        }
        if (other.getAutoMLConfig() == null ^ this.getAutoMLConfig() == null) {
            return false;
        }
        return other.getAutoMLConfig() == null || other.getAutoMLConfig().equals(this.getAutoMLConfig());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEventValueThreshold() == null ? 0 : this.getEventValueThreshold().hashCode());
        hashCode = 31 * hashCode + (this.getHpoConfig() == null ? 0 : this.getHpoConfig().hashCode());
        hashCode = 31 * hashCode + (this.getAlgorithmHyperParameters() == null ? 0 : this.getAlgorithmHyperParameters().hashCode());
        hashCode = 31 * hashCode + (this.getFeatureTransformationParameters() == null ? 0 : this.getFeatureTransformationParameters().hashCode());
        hashCode = 31 * hashCode + (this.getAutoMLConfig() == null ? 0 : this.getAutoMLConfig().hashCode());
        return hashCode;
    }

    public SolutionConfig clone() {
        try {
            return (SolutionConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SolutionConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

