/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.pinpoint.model.APNSMessage;
import java.util.Map;

@SdkInternalApi
public class APNSMessageMarshaller {
    private static final MarshallingInfo<String> ACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Action").build();
    private static final MarshallingInfo<Integer> BADGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Badge").build();
    private static final MarshallingInfo<String> BODY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Body").build();
    private static final MarshallingInfo<String> CATEGORY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Category").build();
    private static final MarshallingInfo<Map> DATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Data").build();
    private static final MarshallingInfo<String> MEDIAURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MediaUrl").build();
    private static final MarshallingInfo<String> RAWCONTENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RawContent").build();
    private static final MarshallingInfo<Boolean> SILENTPUSH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SilentPush").build();
    private static final MarshallingInfo<String> SOUND_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Sound").build();
    private static final MarshallingInfo<Map> SUBSTITUTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Substitutions").build();
    private static final MarshallingInfo<String> THREADID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ThreadId").build();
    private static final MarshallingInfo<String> TITLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Title").build();
    private static final MarshallingInfo<String> URL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Url").build();
    private static final APNSMessageMarshaller instance = new APNSMessageMarshaller();

    public static APNSMessageMarshaller getInstance() {
        return instance;
    }

    public void marshall(APNSMessage aPNSMessage, ProtocolMarshaller protocolMarshaller) {
        if (aPNSMessage == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)aPNSMessage.getAction(), ACTION_BINDING);
            protocolMarshaller.marshall((Object)aPNSMessage.getBadge(), BADGE_BINDING);
            protocolMarshaller.marshall((Object)aPNSMessage.getBody(), BODY_BINDING);
            protocolMarshaller.marshall((Object)aPNSMessage.getCategory(), CATEGORY_BINDING);
            protocolMarshaller.marshall(aPNSMessage.getData(), DATA_BINDING);
            protocolMarshaller.marshall((Object)aPNSMessage.getMediaUrl(), MEDIAURL_BINDING);
            protocolMarshaller.marshall((Object)aPNSMessage.getRawContent(), RAWCONTENT_BINDING);
            protocolMarshaller.marshall((Object)aPNSMessage.getSilentPush(), SILENTPUSH_BINDING);
            protocolMarshaller.marshall((Object)aPNSMessage.getSound(), SOUND_BINDING);
            protocolMarshaller.marshall(aPNSMessage.getSubstitutions(), SUBSTITUTIONS_BINDING);
            protocolMarshaller.marshall((Object)aPNSMessage.getThreadId(), THREADID_BINDING);
            protocolMarshaller.marshall((Object)aPNSMessage.getTitle(), TITLE_BINDING);
            protocolMarshaller.marshall((Object)aPNSMessage.getUrl(), URL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

