/*
 * Copyright 2012-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.pinpoint;

import javax.annotation.Generated;

import com.amazonaws.services.pinpoint.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AmazonPinpoint}. Convenient method forms pass through to the corresponding overload
 * that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonPinpoint implements AmazonPinpoint {

    protected AbstractAmazonPinpoint() {
    }

    @Override
    public void setEndpoint(String endpoint) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void setRegion(com.amazonaws.regions.Region region) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAppResult createApp(CreateAppRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateCampaignResult createCampaign(CreateCampaignRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateImportJobResult createImportJob(CreateImportJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateSegmentResult createSegment(CreateSegmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAdmChannelResult deleteAdmChannel(DeleteAdmChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteApnsChannelResult deleteApnsChannel(DeleteApnsChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteApnsSandboxChannelResult deleteApnsSandboxChannel(DeleteApnsSandboxChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteApnsVoipChannelResult deleteApnsVoipChannel(DeleteApnsVoipChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteApnsVoipSandboxChannelResult deleteApnsVoipSandboxChannel(DeleteApnsVoipSandboxChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAppResult deleteApp(DeleteAppRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteBaiduChannelResult deleteBaiduChannel(DeleteBaiduChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteCampaignResult deleteCampaign(DeleteCampaignRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteEmailChannelResult deleteEmailChannel(DeleteEmailChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteEventStreamResult deleteEventStream(DeleteEventStreamRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteGcmChannelResult deleteGcmChannel(DeleteGcmChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteSegmentResult deleteSegment(DeleteSegmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteSmsChannelResult deleteSmsChannel(DeleteSmsChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAdmChannelResult getAdmChannel(GetAdmChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetApnsChannelResult getApnsChannel(GetApnsChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetApnsSandboxChannelResult getApnsSandboxChannel(GetApnsSandboxChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetApnsVoipChannelResult getApnsVoipChannel(GetApnsVoipChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetApnsVoipSandboxChannelResult getApnsVoipSandboxChannel(GetApnsVoipSandboxChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAppResult getApp(GetAppRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetApplicationSettingsResult getApplicationSettings(GetApplicationSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAppsResult getApps(GetAppsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetBaiduChannelResult getBaiduChannel(GetBaiduChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetCampaignResult getCampaign(GetCampaignRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetCampaignActivitiesResult getCampaignActivities(GetCampaignActivitiesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetCampaignVersionResult getCampaignVersion(GetCampaignVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetCampaignVersionsResult getCampaignVersions(GetCampaignVersionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetCampaignsResult getCampaigns(GetCampaignsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetEmailChannelResult getEmailChannel(GetEmailChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetEndpointResult getEndpoint(GetEndpointRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetEventStreamResult getEventStream(GetEventStreamRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetGcmChannelResult getGcmChannel(GetGcmChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetImportJobResult getImportJob(GetImportJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetImportJobsResult getImportJobs(GetImportJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSegmentResult getSegment(GetSegmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSegmentImportJobsResult getSegmentImportJobs(GetSegmentImportJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSegmentVersionResult getSegmentVersion(GetSegmentVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSegmentVersionsResult getSegmentVersions(GetSegmentVersionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSegmentsResult getSegments(GetSegmentsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSmsChannelResult getSmsChannel(GetSmsChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutEventStreamResult putEventStream(PutEventStreamRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SendMessagesResult sendMessages(SendMessagesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SendUsersMessagesResult sendUsersMessages(SendUsersMessagesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateAdmChannelResult updateAdmChannel(UpdateAdmChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateApnsChannelResult updateApnsChannel(UpdateApnsChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateApnsSandboxChannelResult updateApnsSandboxChannel(UpdateApnsSandboxChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateApnsVoipChannelResult updateApnsVoipChannel(UpdateApnsVoipChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateApnsVoipSandboxChannelResult updateApnsVoipSandboxChannel(UpdateApnsVoipSandboxChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateApplicationSettingsResult updateApplicationSettings(UpdateApplicationSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateBaiduChannelResult updateBaiduChannel(UpdateBaiduChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateCampaignResult updateCampaign(UpdateCampaignRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateEmailChannelResult updateEmailChannel(UpdateEmailChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateEndpointResult updateEndpoint(UpdateEndpointRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateEndpointsBatchResult updateEndpointsBatch(UpdateEndpointsBatchRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateGcmChannelResult updateGcmChannel(UpdateGcmChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateSegmentResult updateSegment(UpdateSegmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateSmsChannelResult updateSmsChannel(UpdateSmsChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
