/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.pinpoint.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateApp" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CreateAppRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    private CreateApplicationRequest createApplicationRequest;

    /**
     * @param createApplicationRequest
     */

    public void setCreateApplicationRequest(CreateApplicationRequest createApplicationRequest) {
        this.createApplicationRequest = createApplicationRequest;
    }

    /**
     * @return
     */

    public CreateApplicationRequest getCreateApplicationRequest() {
        return this.createApplicationRequest;
    }

    /**
     * @param createApplicationRequest
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateAppRequest withCreateApplicationRequest(CreateApplicationRequest createApplicationRequest) {
        setCreateApplicationRequest(createApplicationRequest);
        return this;
    }

    /**
     * Returns a string representation of this object; useful for testing and debugging.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getCreateApplicationRequest() != null)
            sb.append("CreateApplicationRequest: ").append(getCreateApplicationRequest());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof CreateAppRequest == false)
            return false;
        CreateAppRequest other = (CreateAppRequest) obj;
        if (other.getCreateApplicationRequest() == null ^ this.getCreateApplicationRequest() == null)
            return false;
        if (other.getCreateApplicationRequest() != null && other.getCreateApplicationRequest().equals(this.getCreateApplicationRequest()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getCreateApplicationRequest() == null) ? 0 : getCreateApplicationRequest().hashCode());
        return hashCode;
    }

    @Override
    public CreateAppRequest clone() {
        return (CreateAppRequest) super.clone();
    }

}
