/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.pinpoint.model.GetEndpointRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class GetEndpointRequestMarshaller
implements Marshaller<Request<GetEndpointRequest>, GetEndpointRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public GetEndpointRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<GetEndpointRequest> marshall(GetEndpointRequest getEndpointRequest) {
        if (getEndpointRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getEndpointRequest, "AmazonPinpoint");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/v1/apps/{application-id}/endpoints/{endpoint-id}";
        uriResourcePath = uriResourcePath.replace("{application-id}", getEndpointRequest.getApplicationId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)getEndpointRequest.getApplicationId()), (boolean)false) : "");
        uriResourcePath = uriResourcePath.replace("{endpoint-id}", getEndpointRequest.getEndpointId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)getEndpointRequest.getEndpointId()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

