/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.pinpoint.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.pinpoint.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * JourneyExecutionMetricsResponse JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class JourneyExecutionMetricsResponseJsonUnmarshaller implements Unmarshaller<JourneyExecutionMetricsResponse, JsonUnmarshallerContext> {

    public JourneyExecutionMetricsResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        JourneyExecutionMetricsResponse journeyExecutionMetricsResponse = new JourneyExecutionMetricsResponse();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        boolean knownMember;

        while (true) {
            if (token == null)
                break;

            knownMember = false;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("ApplicationId", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    journeyExecutionMetricsResponse.setApplicationId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("JourneyId", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    journeyExecutionMetricsResponse.setJourneyId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("LastEvaluatedTime", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    journeyExecutionMetricsResponse.setLastEvaluatedTime(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Metrics", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    journeyExecutionMetricsResponse.setMetrics(new MapUnmarshaller<String, String>(context.getUnmarshaller(String.class), context
                            .getUnmarshaller(String.class)).unmarshall(context));
                }
                if (token == FIELD_NAME && !knownMember) {
                    context.nextToken();
                    com.amazonaws.transform.UnknownMemberJsonUnmarshaller.getInstance().unmarshall(context);
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return journeyExecutionMetricsResponse;
    }

    private static JourneyExecutionMetricsResponseJsonUnmarshaller instance;

    public static JourneyExecutionMetricsResponseJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new JourneyExecutionMetricsResponseJsonUnmarshaller();
        return instance;
    }
}
