/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.pinpoint.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.pinpoint.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * WriteJourneyRequest JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class WriteJourneyRequestJsonUnmarshaller implements Unmarshaller<WriteJourneyRequest, JsonUnmarshallerContext> {

    public WriteJourneyRequest unmarshall(JsonUnmarshallerContext context) throws Exception {
        WriteJourneyRequest writeJourneyRequest = new WriteJourneyRequest();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("Activities", targetDepth)) {
                    context.nextToken();
                    writeJourneyRequest.setActivities(new MapUnmarshaller<String, Activity>(context.getUnmarshaller(String.class), ActivityJsonUnmarshaller
                            .getInstance()).unmarshall(context));
                }
                if (context.testExpression("CreationDate", targetDepth)) {
                    context.nextToken();
                    writeJourneyRequest.setCreationDate(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("LastModifiedDate", targetDepth)) {
                    context.nextToken();
                    writeJourneyRequest.setLastModifiedDate(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Limits", targetDepth)) {
                    context.nextToken();
                    writeJourneyRequest.setLimits(JourneyLimitsJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("LocalTime", targetDepth)) {
                    context.nextToken();
                    writeJourneyRequest.setLocalTime(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    writeJourneyRequest.setName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("QuietTime", targetDepth)) {
                    context.nextToken();
                    writeJourneyRequest.setQuietTime(QuietTimeJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("RefreshFrequency", targetDepth)) {
                    context.nextToken();
                    writeJourneyRequest.setRefreshFrequency(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Schedule", targetDepth)) {
                    context.nextToken();
                    writeJourneyRequest.setSchedule(JourneyScheduleJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("StartActivity", targetDepth)) {
                    context.nextToken();
                    writeJourneyRequest.setStartActivity(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("StartCondition", targetDepth)) {
                    context.nextToken();
                    writeJourneyRequest.setStartCondition(StartConditionJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("State", targetDepth)) {
                    context.nextToken();
                    writeJourneyRequest.setState(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("WaitForQuietTime", targetDepth)) {
                    context.nextToken();
                    writeJourneyRequest.setWaitForQuietTime(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("RefreshOnSegmentUpdate", targetDepth)) {
                    context.nextToken();
                    writeJourneyRequest.setRefreshOnSegmentUpdate(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("JourneyChannelSettings", targetDepth)) {
                    context.nextToken();
                    writeJourneyRequest.setJourneyChannelSettings(JourneyChannelSettingsJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("SendingSchedule", targetDepth)) {
                    context.nextToken();
                    writeJourneyRequest.setSendingSchedule(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("OpenHours", targetDepth)) {
                    context.nextToken();
                    writeJourneyRequest.setOpenHours(OpenHoursJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("ClosedDays", targetDepth)) {
                    context.nextToken();
                    writeJourneyRequest.setClosedDays(ClosedDaysJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("TimezoneEstimationMethods", targetDepth)) {
                    context.nextToken();
                    writeJourneyRequest.setTimezoneEstimationMethods(new ListUnmarshaller<String>(context.getUnmarshaller(String.class))

                    .unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return writeJourneyRequest;
    }

    private static WriteJourneyRequestJsonUnmarshaller instance;

    public static WriteJourneyRequestJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new WriteJourneyRequestJsonUnmarshaller();
        return instance;
    }
}
