/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpointsmsvoice;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.pinpointsmsvoice.AmazonPinpointSMSVoice;
import com.amazonaws.services.pinpointsmsvoice.AmazonPinpointSMSVoiceClientBuilder;
import com.amazonaws.services.pinpointsmsvoice.model.AmazonPinpointSMSVoiceException;
import com.amazonaws.services.pinpointsmsvoice.model.CreateConfigurationSetEventDestinationRequest;
import com.amazonaws.services.pinpointsmsvoice.model.CreateConfigurationSetEventDestinationResult;
import com.amazonaws.services.pinpointsmsvoice.model.CreateConfigurationSetRequest;
import com.amazonaws.services.pinpointsmsvoice.model.CreateConfigurationSetResult;
import com.amazonaws.services.pinpointsmsvoice.model.DeleteConfigurationSetEventDestinationRequest;
import com.amazonaws.services.pinpointsmsvoice.model.DeleteConfigurationSetEventDestinationResult;
import com.amazonaws.services.pinpointsmsvoice.model.DeleteConfigurationSetRequest;
import com.amazonaws.services.pinpointsmsvoice.model.DeleteConfigurationSetResult;
import com.amazonaws.services.pinpointsmsvoice.model.GetConfigurationSetEventDestinationsRequest;
import com.amazonaws.services.pinpointsmsvoice.model.GetConfigurationSetEventDestinationsResult;
import com.amazonaws.services.pinpointsmsvoice.model.ListConfigurationSetsRequest;
import com.amazonaws.services.pinpointsmsvoice.model.ListConfigurationSetsResult;
import com.amazonaws.services.pinpointsmsvoice.model.SendVoiceMessageRequest;
import com.amazonaws.services.pinpointsmsvoice.model.SendVoiceMessageResult;
import com.amazonaws.services.pinpointsmsvoice.model.UpdateConfigurationSetEventDestinationRequest;
import com.amazonaws.services.pinpointsmsvoice.model.UpdateConfigurationSetEventDestinationResult;
import com.amazonaws.services.pinpointsmsvoice.model.transform.AlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.pinpointsmsvoice.model.transform.BadRequestExceptionUnmarshaller;
import com.amazonaws.services.pinpointsmsvoice.model.transform.CreateConfigurationSetEventDestinationRequestProtocolMarshaller;
import com.amazonaws.services.pinpointsmsvoice.model.transform.CreateConfigurationSetEventDestinationResultJsonUnmarshaller;
import com.amazonaws.services.pinpointsmsvoice.model.transform.CreateConfigurationSetRequestProtocolMarshaller;
import com.amazonaws.services.pinpointsmsvoice.model.transform.CreateConfigurationSetResultJsonUnmarshaller;
import com.amazonaws.services.pinpointsmsvoice.model.transform.DeleteConfigurationSetEventDestinationRequestProtocolMarshaller;
import com.amazonaws.services.pinpointsmsvoice.model.transform.DeleteConfigurationSetEventDestinationResultJsonUnmarshaller;
import com.amazonaws.services.pinpointsmsvoice.model.transform.DeleteConfigurationSetRequestProtocolMarshaller;
import com.amazonaws.services.pinpointsmsvoice.model.transform.DeleteConfigurationSetResultJsonUnmarshaller;
import com.amazonaws.services.pinpointsmsvoice.model.transform.GetConfigurationSetEventDestinationsRequestProtocolMarshaller;
import com.amazonaws.services.pinpointsmsvoice.model.transform.GetConfigurationSetEventDestinationsResultJsonUnmarshaller;
import com.amazonaws.services.pinpointsmsvoice.model.transform.InternalServiceErrorExceptionUnmarshaller;
import com.amazonaws.services.pinpointsmsvoice.model.transform.LimitExceededExceptionUnmarshaller;
import com.amazonaws.services.pinpointsmsvoice.model.transform.ListConfigurationSetsRequestProtocolMarshaller;
import com.amazonaws.services.pinpointsmsvoice.model.transform.ListConfigurationSetsResultJsonUnmarshaller;
import com.amazonaws.services.pinpointsmsvoice.model.transform.NotFoundExceptionUnmarshaller;
import com.amazonaws.services.pinpointsmsvoice.model.transform.SendVoiceMessageRequestProtocolMarshaller;
import com.amazonaws.services.pinpointsmsvoice.model.transform.SendVoiceMessageResultJsonUnmarshaller;
import com.amazonaws.services.pinpointsmsvoice.model.transform.TooManyRequestsExceptionUnmarshaller;
import com.amazonaws.services.pinpointsmsvoice.model.transform.UpdateConfigurationSetEventDestinationRequestProtocolMarshaller;
import com.amazonaws.services.pinpointsmsvoice.model.transform.UpdateConfigurationSetEventDestinationResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonPinpointSMSVoiceClient
extends AmazonWebServiceClient
implements AmazonPinpointSMSVoice {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonPinpointSMSVoice.class);
    private static final String DEFAULT_SIGNING_NAME = "sms-voice";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)NotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServiceErrorException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServiceErrorExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AlreadyExistsException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AlreadyExistsExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TooManyRequestsException").withExceptionUnmarshaller((JsonErrorUnmarshaller)TooManyRequestsExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BadRequestException").withExceptionUnmarshaller((JsonErrorUnmarshaller)BadRequestExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)LimitExceededExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AmazonPinpointSMSVoiceException.class));

    public static AmazonPinpointSMSVoiceClientBuilder builder() {
        return AmazonPinpointSMSVoiceClientBuilder.standard();
    }

    AmazonPinpointSMSVoiceClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonPinpointSMSVoiceClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix("sms-voice.pinpoint");
        this.setEndpoint("sms-voice.pinpoint.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/pinpointsmsvoice/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/pinpointsmsvoice/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateConfigurationSetResult createConfigurationSet(CreateConfigurationSetRequest request) {
        request = (CreateConfigurationSetRequest)this.beforeClientExecution(request);
        return this.executeCreateConfigurationSet(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateConfigurationSetResult executeCreateConfigurationSet(CreateConfigurationSetRequest createConfigurationSetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createConfigurationSetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateConfigurationSetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateConfigurationSetRequestProtocolMarshaller(protocolFactory).marshall((CreateConfigurationSetRequest)super.beforeMarshalling((AmazonWebServiceRequest)createConfigurationSetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Pinpoint SMS Voice");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateConfigurationSet");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateConfigurationSetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateConfigurationSetResult createConfigurationSetResult = (CreateConfigurationSetResult)response.getAwsResponse();
            return createConfigurationSetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateConfigurationSetEventDestinationResult createConfigurationSetEventDestination(CreateConfigurationSetEventDestinationRequest request) {
        request = (CreateConfigurationSetEventDestinationRequest)this.beforeClientExecution(request);
        return this.executeCreateConfigurationSetEventDestination(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateConfigurationSetEventDestinationResult executeCreateConfigurationSetEventDestination(CreateConfigurationSetEventDestinationRequest createConfigurationSetEventDestinationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createConfigurationSetEventDestinationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateConfigurationSetEventDestinationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateConfigurationSetEventDestinationRequestProtocolMarshaller(protocolFactory).marshall((CreateConfigurationSetEventDestinationRequest)super.beforeMarshalling((AmazonWebServiceRequest)createConfigurationSetEventDestinationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Pinpoint SMS Voice");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateConfigurationSetEventDestination");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateConfigurationSetEventDestinationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateConfigurationSetEventDestinationResult createConfigurationSetEventDestinationResult = (CreateConfigurationSetEventDestinationResult)response.getAwsResponse();
            return createConfigurationSetEventDestinationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteConfigurationSetResult deleteConfigurationSet(DeleteConfigurationSetRequest request) {
        request = (DeleteConfigurationSetRequest)this.beforeClientExecution(request);
        return this.executeDeleteConfigurationSet(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteConfigurationSetResult executeDeleteConfigurationSet(DeleteConfigurationSetRequest deleteConfigurationSetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteConfigurationSetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteConfigurationSetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteConfigurationSetRequestProtocolMarshaller(protocolFactory).marshall((DeleteConfigurationSetRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteConfigurationSetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Pinpoint SMS Voice");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteConfigurationSet");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteConfigurationSetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteConfigurationSetResult deleteConfigurationSetResult = (DeleteConfigurationSetResult)response.getAwsResponse();
            return deleteConfigurationSetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteConfigurationSetEventDestinationResult deleteConfigurationSetEventDestination(DeleteConfigurationSetEventDestinationRequest request) {
        request = (DeleteConfigurationSetEventDestinationRequest)this.beforeClientExecution(request);
        return this.executeDeleteConfigurationSetEventDestination(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteConfigurationSetEventDestinationResult executeDeleteConfigurationSetEventDestination(DeleteConfigurationSetEventDestinationRequest deleteConfigurationSetEventDestinationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteConfigurationSetEventDestinationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteConfigurationSetEventDestinationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteConfigurationSetEventDestinationRequestProtocolMarshaller(protocolFactory).marshall((DeleteConfigurationSetEventDestinationRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteConfigurationSetEventDestinationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Pinpoint SMS Voice");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteConfigurationSetEventDestination");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteConfigurationSetEventDestinationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteConfigurationSetEventDestinationResult deleteConfigurationSetEventDestinationResult = (DeleteConfigurationSetEventDestinationResult)response.getAwsResponse();
            return deleteConfigurationSetEventDestinationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetConfigurationSetEventDestinationsResult getConfigurationSetEventDestinations(GetConfigurationSetEventDestinationsRequest request) {
        request = (GetConfigurationSetEventDestinationsRequest)this.beforeClientExecution(request);
        return this.executeGetConfigurationSetEventDestinations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetConfigurationSetEventDestinationsResult executeGetConfigurationSetEventDestinations(GetConfigurationSetEventDestinationsRequest getConfigurationSetEventDestinationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getConfigurationSetEventDestinationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetConfigurationSetEventDestinationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetConfigurationSetEventDestinationsRequestProtocolMarshaller(protocolFactory).marshall((GetConfigurationSetEventDestinationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)getConfigurationSetEventDestinationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Pinpoint SMS Voice");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetConfigurationSetEventDestinations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetConfigurationSetEventDestinationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetConfigurationSetEventDestinationsResult getConfigurationSetEventDestinationsResult = (GetConfigurationSetEventDestinationsResult)response.getAwsResponse();
            return getConfigurationSetEventDestinationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListConfigurationSetsResult listConfigurationSets(ListConfigurationSetsRequest request) {
        request = (ListConfigurationSetsRequest)this.beforeClientExecution(request);
        return this.executeListConfigurationSets(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListConfigurationSetsResult executeListConfigurationSets(ListConfigurationSetsRequest listConfigurationSetsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listConfigurationSetsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListConfigurationSetsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListConfigurationSetsRequestProtocolMarshaller(protocolFactory).marshall((ListConfigurationSetsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listConfigurationSetsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Pinpoint SMS Voice");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListConfigurationSets");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListConfigurationSetsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListConfigurationSetsResult listConfigurationSetsResult = (ListConfigurationSetsResult)response.getAwsResponse();
            return listConfigurationSetsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public SendVoiceMessageResult sendVoiceMessage(SendVoiceMessageRequest request) {
        request = (SendVoiceMessageRequest)this.beforeClientExecution(request);
        return this.executeSendVoiceMessage(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final SendVoiceMessageResult executeSendVoiceMessage(SendVoiceMessageRequest sendVoiceMessageRequest) {
        ExecutionContext executionContext = this.createExecutionContext(sendVoiceMessageRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SendVoiceMessageRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SendVoiceMessageRequestProtocolMarshaller(protocolFactory).marshall((SendVoiceMessageRequest)super.beforeMarshalling((AmazonWebServiceRequest)sendVoiceMessageRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Pinpoint SMS Voice");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"SendVoiceMessage");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new SendVoiceMessageResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            SendVoiceMessageResult sendVoiceMessageResult = (SendVoiceMessageResult)response.getAwsResponse();
            return sendVoiceMessageResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateConfigurationSetEventDestinationResult updateConfigurationSetEventDestination(UpdateConfigurationSetEventDestinationRequest request) {
        request = (UpdateConfigurationSetEventDestinationRequest)this.beforeClientExecution(request);
        return this.executeUpdateConfigurationSetEventDestination(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateConfigurationSetEventDestinationResult executeUpdateConfigurationSetEventDestination(UpdateConfigurationSetEventDestinationRequest updateConfigurationSetEventDestinationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateConfigurationSetEventDestinationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateConfigurationSetEventDestinationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateConfigurationSetEventDestinationRequestProtocolMarshaller(protocolFactory).marshall((UpdateConfigurationSetEventDestinationRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateConfigurationSetEventDestinationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Pinpoint SMS Voice");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateConfigurationSetEventDestination");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateConfigurationSetEventDestinationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateConfigurationSetEventDestinationResult updateConfigurationSetEventDestinationResult = (UpdateConfigurationSetEventDestinationResult)response.getAwsResponse();
            return updateConfigurationSetEventDestinationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

