/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.pinpointsmsvoicev2.model.transform;

import java.util.List;
import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.pinpointsmsvoicev2.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * DescribeVerifiedDestinationNumbersRequestMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class DescribeVerifiedDestinationNumbersRequestMarshaller {

    private static final MarshallingInfo<List> VERIFIEDDESTINATIONNUMBERIDS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VerifiedDestinationNumberIds").build();
    private static final MarshallingInfo<List> DESTINATIONPHONENUMBERS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DestinationPhoneNumbers").build();
    private static final MarshallingInfo<List> FILTERS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("Filters").build();
    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("NextToken").build();
    private static final MarshallingInfo<Integer> MAXRESULTS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxResults").build();

    private static final DescribeVerifiedDestinationNumbersRequestMarshaller instance = new DescribeVerifiedDestinationNumbersRequestMarshaller();

    public static DescribeVerifiedDestinationNumbersRequestMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(DescribeVerifiedDestinationNumbersRequest describeVerifiedDestinationNumbersRequest, ProtocolMarshaller protocolMarshaller) {

        if (describeVerifiedDestinationNumbersRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(describeVerifiedDestinationNumbersRequest.getVerifiedDestinationNumberIds(), VERIFIEDDESTINATIONNUMBERIDS_BINDING);
            protocolMarshaller.marshall(describeVerifiedDestinationNumbersRequest.getDestinationPhoneNumbers(), DESTINATIONPHONENUMBERS_BINDING);
            protocolMarshaller.marshall(describeVerifiedDestinationNumbersRequest.getFilters(), FILTERS_BINDING);
            protocolMarshaller.marshall(describeVerifiedDestinationNumbersRequest.getNextToken(), NEXTTOKEN_BINDING);
            protocolMarshaller.marshall(describeVerifiedDestinationNumbersRequest.getMaxResults(), MAXRESULTS_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
