/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pipes.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.pipes.model.transform.PipeEnrichmentHttpParametersMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PipeEnrichmentHttpParameters
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> pathParameterValues;
    private Map<String, String> headerParameters;
    private Map<String, String> queryStringParameters;

    public List<String> getPathParameterValues() {
        return this.pathParameterValues;
    }

    public void setPathParameterValues(Collection<String> pathParameterValues) {
        if (pathParameterValues == null) {
            this.pathParameterValues = null;
            return;
        }
        this.pathParameterValues = new ArrayList<String>(pathParameterValues);
    }

    public PipeEnrichmentHttpParameters withPathParameterValues(String ... pathParameterValues) {
        if (this.pathParameterValues == null) {
            this.setPathParameterValues(new ArrayList<String>(pathParameterValues.length));
        }
        for (String ele : pathParameterValues) {
            this.pathParameterValues.add(ele);
        }
        return this;
    }

    public PipeEnrichmentHttpParameters withPathParameterValues(Collection<String> pathParameterValues) {
        this.setPathParameterValues(pathParameterValues);
        return this;
    }

    public Map<String, String> getHeaderParameters() {
        return this.headerParameters;
    }

    public void setHeaderParameters(Map<String, String> headerParameters) {
        this.headerParameters = headerParameters;
    }

    public PipeEnrichmentHttpParameters withHeaderParameters(Map<String, String> headerParameters) {
        this.setHeaderParameters(headerParameters);
        return this;
    }

    public PipeEnrichmentHttpParameters addHeaderParametersEntry(String key, String value) {
        if (null == this.headerParameters) {
            this.headerParameters = new HashMap<String, String>();
        }
        if (this.headerParameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.headerParameters.put(key, value);
        return this;
    }

    public PipeEnrichmentHttpParameters clearHeaderParametersEntries() {
        this.headerParameters = null;
        return this;
    }

    public Map<String, String> getQueryStringParameters() {
        return this.queryStringParameters;
    }

    public void setQueryStringParameters(Map<String, String> queryStringParameters) {
        this.queryStringParameters = queryStringParameters;
    }

    public PipeEnrichmentHttpParameters withQueryStringParameters(Map<String, String> queryStringParameters) {
        this.setQueryStringParameters(queryStringParameters);
        return this;
    }

    public PipeEnrichmentHttpParameters addQueryStringParametersEntry(String key, String value) {
        if (null == this.queryStringParameters) {
            this.queryStringParameters = new HashMap<String, String>();
        }
        if (this.queryStringParameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.queryStringParameters.put(key, value);
        return this;
    }

    public PipeEnrichmentHttpParameters clearQueryStringParametersEntries() {
        this.queryStringParameters = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPathParameterValues() != null) {
            sb.append("PathParameterValues: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getHeaderParameters() != null) {
            sb.append("HeaderParameters: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getQueryStringParameters() != null) {
            sb.append("QueryStringParameters: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipeEnrichmentHttpParameters)) {
            return false;
        }
        PipeEnrichmentHttpParameters other = (PipeEnrichmentHttpParameters)obj;
        if (other.getPathParameterValues() == null ^ this.getPathParameterValues() == null) {
            return false;
        }
        if (other.getPathParameterValues() != null && !other.getPathParameterValues().equals(this.getPathParameterValues())) {
            return false;
        }
        if (other.getHeaderParameters() == null ^ this.getHeaderParameters() == null) {
            return false;
        }
        if (other.getHeaderParameters() != null && !other.getHeaderParameters().equals(this.getHeaderParameters())) {
            return false;
        }
        if (other.getQueryStringParameters() == null ^ this.getQueryStringParameters() == null) {
            return false;
        }
        return other.getQueryStringParameters() == null || other.getQueryStringParameters().equals(this.getQueryStringParameters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPathParameterValues() == null ? 0 : this.getPathParameterValues().hashCode());
        hashCode = 31 * hashCode + (this.getHeaderParameters() == null ? 0 : this.getHeaderParameters().hashCode());
        hashCode = 31 * hashCode + (this.getQueryStringParameters() == null ? 0 : this.getQueryStringParameters().hashCode());
        return hashCode;
    }

    public PipeEnrichmentHttpParameters clone() {
        try {
            return (PipeEnrichmentHttpParameters)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PipeEnrichmentHttpParametersMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

