/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.polly.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.polly.model.Engine;
import com.amazonaws.services.polly.model.Gender;
import com.amazonaws.services.polly.model.LanguageCode;
import com.amazonaws.services.polly.model.VoiceId;
import com.amazonaws.services.polly.model.transform.VoiceMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Voice
implements Serializable,
Cloneable,
StructuredPojo {
    private String gender;
    private String id;
    private String languageCode;
    private String languageName;
    private String name;
    private List<String> additionalLanguageCodes;
    private List<String> supportedEngines;

    public void setGender(String gender) {
        this.gender = gender;
    }

    public String getGender() {
        return this.gender;
    }

    public Voice withGender(String gender) {
        this.setGender(gender);
        return this;
    }

    public void setGender(Gender gender) {
        this.withGender(gender);
    }

    public Voice withGender(Gender gender) {
        this.gender = gender.toString();
        return this;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Voice withId(String id) {
        this.setId(id);
        return this;
    }

    public void setId(VoiceId id) {
        this.withId(id);
    }

    public Voice withId(VoiceId id) {
        this.id = id.toString();
        return this;
    }

    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public Voice withLanguageCode(String languageCode) {
        this.setLanguageCode(languageCode);
        return this;
    }

    public void setLanguageCode(LanguageCode languageCode) {
        this.withLanguageCode(languageCode);
    }

    public Voice withLanguageCode(LanguageCode languageCode) {
        this.languageCode = languageCode.toString();
        return this;
    }

    public void setLanguageName(String languageName) {
        this.languageName = languageName;
    }

    public String getLanguageName() {
        return this.languageName;
    }

    public Voice withLanguageName(String languageName) {
        this.setLanguageName(languageName);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Voice withName(String name) {
        this.setName(name);
        return this;
    }

    public List<String> getAdditionalLanguageCodes() {
        return this.additionalLanguageCodes;
    }

    public void setAdditionalLanguageCodes(Collection<String> additionalLanguageCodes) {
        if (additionalLanguageCodes == null) {
            this.additionalLanguageCodes = null;
            return;
        }
        this.additionalLanguageCodes = new ArrayList<String>(additionalLanguageCodes);
    }

    public Voice withAdditionalLanguageCodes(String ... additionalLanguageCodes) {
        if (this.additionalLanguageCodes == null) {
            this.setAdditionalLanguageCodes(new ArrayList<String>(additionalLanguageCodes.length));
        }
        for (String ele : additionalLanguageCodes) {
            this.additionalLanguageCodes.add(ele);
        }
        return this;
    }

    public Voice withAdditionalLanguageCodes(Collection<String> additionalLanguageCodes) {
        this.setAdditionalLanguageCodes(additionalLanguageCodes);
        return this;
    }

    public Voice withAdditionalLanguageCodes(LanguageCode ... additionalLanguageCodes) {
        ArrayList<String> additionalLanguageCodesCopy = new ArrayList<String>(additionalLanguageCodes.length);
        for (LanguageCode value : additionalLanguageCodes) {
            additionalLanguageCodesCopy.add(value.toString());
        }
        if (this.getAdditionalLanguageCodes() == null) {
            this.setAdditionalLanguageCodes(additionalLanguageCodesCopy);
        } else {
            this.getAdditionalLanguageCodes().addAll(additionalLanguageCodesCopy);
        }
        return this;
    }

    public List<String> getSupportedEngines() {
        return this.supportedEngines;
    }

    public void setSupportedEngines(Collection<String> supportedEngines) {
        if (supportedEngines == null) {
            this.supportedEngines = null;
            return;
        }
        this.supportedEngines = new ArrayList<String>(supportedEngines);
    }

    public Voice withSupportedEngines(String ... supportedEngines) {
        if (this.supportedEngines == null) {
            this.setSupportedEngines(new ArrayList<String>(supportedEngines.length));
        }
        for (String ele : supportedEngines) {
            this.supportedEngines.add(ele);
        }
        return this;
    }

    public Voice withSupportedEngines(Collection<String> supportedEngines) {
        this.setSupportedEngines(supportedEngines);
        return this;
    }

    public Voice withSupportedEngines(Engine ... supportedEngines) {
        ArrayList<String> supportedEnginesCopy = new ArrayList<String>(supportedEngines.length);
        for (Engine value : supportedEngines) {
            supportedEnginesCopy.add(value.toString());
        }
        if (this.getSupportedEngines() == null) {
            this.setSupportedEngines(supportedEnginesCopy);
        } else {
            this.getSupportedEngines().addAll(supportedEnginesCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getGender() != null) {
            sb.append("Gender: ").append(this.getGender()).append(",");
        }
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getLanguageCode() != null) {
            sb.append("LanguageCode: ").append(this.getLanguageCode()).append(",");
        }
        if (this.getLanguageName() != null) {
            sb.append("LanguageName: ").append(this.getLanguageName()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getAdditionalLanguageCodes() != null) {
            sb.append("AdditionalLanguageCodes: ").append(this.getAdditionalLanguageCodes()).append(",");
        }
        if (this.getSupportedEngines() != null) {
            sb.append("SupportedEngines: ").append(this.getSupportedEngines());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Voice)) {
            return false;
        }
        Voice other = (Voice)obj;
        if (other.getGender() == null ^ this.getGender() == null) {
            return false;
        }
        if (other.getGender() != null && !other.getGender().equals(this.getGender())) {
            return false;
        }
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getLanguageCode() == null ^ this.getLanguageCode() == null) {
            return false;
        }
        if (other.getLanguageCode() != null && !other.getLanguageCode().equals(this.getLanguageCode())) {
            return false;
        }
        if (other.getLanguageName() == null ^ this.getLanguageName() == null) {
            return false;
        }
        if (other.getLanguageName() != null && !other.getLanguageName().equals(this.getLanguageName())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getAdditionalLanguageCodes() == null ^ this.getAdditionalLanguageCodes() == null) {
            return false;
        }
        if (other.getAdditionalLanguageCodes() != null && !other.getAdditionalLanguageCodes().equals(this.getAdditionalLanguageCodes())) {
            return false;
        }
        if (other.getSupportedEngines() == null ^ this.getSupportedEngines() == null) {
            return false;
        }
        return other.getSupportedEngines() == null || other.getSupportedEngines().equals(this.getSupportedEngines());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getGender() == null ? 0 : this.getGender().hashCode());
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getLanguageCode() == null ? 0 : this.getLanguageCode().hashCode());
        hashCode = 31 * hashCode + (this.getLanguageName() == null ? 0 : this.getLanguageName().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getAdditionalLanguageCodes() == null ? 0 : this.getAdditionalLanguageCodes().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedEngines() == null ? 0 : this.getSupportedEngines().hashCode());
        return hashCode;
    }

    public Voice clone() {
        try {
            return (Voice)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        VoiceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

