/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.private5g;

import javax.annotation.Generated;

import com.amazonaws.services.private5g.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSPrivate5G}. Convenient method forms pass through to the corresponding overload
 * that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSPrivate5G implements AWSPrivate5G {

    protected AbstractAWSPrivate5G() {
    }

    @Override
    public AcknowledgeOrderReceiptResult acknowledgeOrderReceipt(AcknowledgeOrderReceiptRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ActivateDeviceIdentifierResult activateDeviceIdentifier(ActivateDeviceIdentifierRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ActivateNetworkSiteResult activateNetworkSite(ActivateNetworkSiteRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ConfigureAccessPointResult configureAccessPoint(ConfigureAccessPointRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateNetworkResult createNetwork(CreateNetworkRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateNetworkSiteResult createNetworkSite(CreateNetworkSiteRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeactivateDeviceIdentifierResult deactivateDeviceIdentifier(DeactivateDeviceIdentifierRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteNetworkResult deleteNetwork(DeleteNetworkRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteNetworkSiteResult deleteNetworkSite(DeleteNetworkSiteRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDeviceIdentifierResult getDeviceIdentifier(GetDeviceIdentifierRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetNetworkResult getNetwork(GetNetworkRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetNetworkResourceResult getNetworkResource(GetNetworkResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetNetworkSiteResult getNetworkSite(GetNetworkSiteRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetOrderResult getOrder(GetOrderRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDeviceIdentifiersResult listDeviceIdentifiers(ListDeviceIdentifiersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListNetworkResourcesResult listNetworkResources(ListNetworkResourcesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListNetworkSitesResult listNetworkSites(ListNetworkSitesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListNetworksResult listNetworks(ListNetworksRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListOrdersResult listOrders(ListOrdersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PingResult ping(PingRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateNetworkSiteResult updateNetworkSite(UpdateNetworkSiteRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateNetworkSitePlanResult updateNetworkSitePlan(UpdateNetworkSitePlanRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
