/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.prometheus.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * The status information about a rule groups namespace.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/RuleGroupsNamespaceStatus" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class RuleGroupsNamespaceStatus implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The current status of the namespace.
     * </p>
     */
    private String statusCode;
    /**
     * <p>
     * The reason for the failure, if any.
     * </p>
     */
    private String statusReason;

    /**
     * <p>
     * The current status of the namespace.
     * </p>
     * 
     * @param statusCode
     *        The current status of the namespace.
     * @see RuleGroupsNamespaceStatusCode
     */

    public void setStatusCode(String statusCode) {
        this.statusCode = statusCode;
    }

    /**
     * <p>
     * The current status of the namespace.
     * </p>
     * 
     * @return The current status of the namespace.
     * @see RuleGroupsNamespaceStatusCode
     */

    public String getStatusCode() {
        return this.statusCode;
    }

    /**
     * <p>
     * The current status of the namespace.
     * </p>
     * 
     * @param statusCode
     *        The current status of the namespace.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see RuleGroupsNamespaceStatusCode
     */

    public RuleGroupsNamespaceStatus withStatusCode(String statusCode) {
        setStatusCode(statusCode);
        return this;
    }

    /**
     * <p>
     * The current status of the namespace.
     * </p>
     * 
     * @param statusCode
     *        The current status of the namespace.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see RuleGroupsNamespaceStatusCode
     */

    public RuleGroupsNamespaceStatus withStatusCode(RuleGroupsNamespaceStatusCode statusCode) {
        this.statusCode = statusCode.toString();
        return this;
    }

    /**
     * <p>
     * The reason for the failure, if any.
     * </p>
     * 
     * @param statusReason
     *        The reason for the failure, if any.
     */

    public void setStatusReason(String statusReason) {
        this.statusReason = statusReason;
    }

    /**
     * <p>
     * The reason for the failure, if any.
     * </p>
     * 
     * @return The reason for the failure, if any.
     */

    public String getStatusReason() {
        return this.statusReason;
    }

    /**
     * <p>
     * The reason for the failure, if any.
     * </p>
     * 
     * @param statusReason
     *        The reason for the failure, if any.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public RuleGroupsNamespaceStatus withStatusReason(String statusReason) {
        setStatusReason(statusReason);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getStatusCode() != null)
            sb.append("StatusCode: ").append(getStatusCode()).append(",");
        if (getStatusReason() != null)
            sb.append("StatusReason: ").append(getStatusReason());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof RuleGroupsNamespaceStatus == false)
            return false;
        RuleGroupsNamespaceStatus other = (RuleGroupsNamespaceStatus) obj;
        if (other.getStatusCode() == null ^ this.getStatusCode() == null)
            return false;
        if (other.getStatusCode() != null && other.getStatusCode().equals(this.getStatusCode()) == false)
            return false;
        if (other.getStatusReason() == null ^ this.getStatusReason() == null)
            return false;
        if (other.getStatusReason() != null && other.getStatusReason().equals(this.getStatusReason()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getStatusCode() == null) ? 0 : getStatusCode().hashCode());
        hashCode = prime * hashCode + ((getStatusReason() == null) ? 0 : getStatusReason().hashCode());
        return hashCode;
    }

    @Override
    public RuleGroupsNamespaceStatus clone() {
        try {
            return (RuleGroupsNamespaceStatus) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.prometheus.model.transform.RuleGroupsNamespaceStatusMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
