/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.proton.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * A filtering criterion to scope down the result list of the <a>ListServiceInstances</a> action.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListServiceInstancesFilter" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListServiceInstancesFilter implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The name of a filtering criterion.
     * </p>
     */
    private String key;
    /**
     * <p>
     * A value to filter by.
     * </p>
     * <p>
     * With the date/time keys (<code>*At{Before,After}</code>), the value is a valid <a
     * href="https://datatracker.ietf.org/doc/html/rfc3339.html">RFC 3339</a> string with no UTC offset and with an
     * optional fractional precision (for example, <code>1985-04-12T23:20:50.52Z</code>).
     * </p>
     */
    private String value;

    /**
     * <p>
     * The name of a filtering criterion.
     * </p>
     * 
     * @param key
     *        The name of a filtering criterion.
     * @see ListServiceInstancesFilterBy
     */

    public void setKey(String key) {
        this.key = key;
    }

    /**
     * <p>
     * The name of a filtering criterion.
     * </p>
     * 
     * @return The name of a filtering criterion.
     * @see ListServiceInstancesFilterBy
     */

    public String getKey() {
        return this.key;
    }

    /**
     * <p>
     * The name of a filtering criterion.
     * </p>
     * 
     * @param key
     *        The name of a filtering criterion.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ListServiceInstancesFilterBy
     */

    public ListServiceInstancesFilter withKey(String key) {
        setKey(key);
        return this;
    }

    /**
     * <p>
     * The name of a filtering criterion.
     * </p>
     * 
     * @param key
     *        The name of a filtering criterion.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ListServiceInstancesFilterBy
     */

    public ListServiceInstancesFilter withKey(ListServiceInstancesFilterBy key) {
        this.key = key.toString();
        return this;
    }

    /**
     * <p>
     * A value to filter by.
     * </p>
     * <p>
     * With the date/time keys (<code>*At{Before,After}</code>), the value is a valid <a
     * href="https://datatracker.ietf.org/doc/html/rfc3339.html">RFC 3339</a> string with no UTC offset and with an
     * optional fractional precision (for example, <code>1985-04-12T23:20:50.52Z</code>).
     * </p>
     * 
     * @param value
     *        A value to filter by.</p>
     *        <p>
     *        With the date/time keys (<code>*At{Before,After}</code>), the value is a valid <a
     *        href="https://datatracker.ietf.org/doc/html/rfc3339.html">RFC 3339</a> string with no UTC offset and with
     *        an optional fractional precision (for example, <code>1985-04-12T23:20:50.52Z</code>).
     */

    public void setValue(String value) {
        this.value = value;
    }

    /**
     * <p>
     * A value to filter by.
     * </p>
     * <p>
     * With the date/time keys (<code>*At{Before,After}</code>), the value is a valid <a
     * href="https://datatracker.ietf.org/doc/html/rfc3339.html">RFC 3339</a> string with no UTC offset and with an
     * optional fractional precision (for example, <code>1985-04-12T23:20:50.52Z</code>).
     * </p>
     * 
     * @return A value to filter by.</p>
     *         <p>
     *         With the date/time keys (<code>*At{Before,After}</code>), the value is a valid <a
     *         href="https://datatracker.ietf.org/doc/html/rfc3339.html">RFC 3339</a> string with no UTC offset and with
     *         an optional fractional precision (for example, <code>1985-04-12T23:20:50.52Z</code>).
     */

    public String getValue() {
        return this.value;
    }

    /**
     * <p>
     * A value to filter by.
     * </p>
     * <p>
     * With the date/time keys (<code>*At{Before,After}</code>), the value is a valid <a
     * href="https://datatracker.ietf.org/doc/html/rfc3339.html">RFC 3339</a> string with no UTC offset and with an
     * optional fractional precision (for example, <code>1985-04-12T23:20:50.52Z</code>).
     * </p>
     * 
     * @param value
     *        A value to filter by.</p>
     *        <p>
     *        With the date/time keys (<code>*At{Before,After}</code>), the value is a valid <a
     *        href="https://datatracker.ietf.org/doc/html/rfc3339.html">RFC 3339</a> string with no UTC offset and with
     *        an optional fractional precision (for example, <code>1985-04-12T23:20:50.52Z</code>).
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListServiceInstancesFilter withValue(String value) {
        setValue(value);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getKey() != null)
            sb.append("Key: ").append(getKey()).append(",");
        if (getValue() != null)
            sb.append("Value: ").append(getValue());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListServiceInstancesFilter == false)
            return false;
        ListServiceInstancesFilter other = (ListServiceInstancesFilter) obj;
        if (other.getKey() == null ^ this.getKey() == null)
            return false;
        if (other.getKey() != null && other.getKey().equals(this.getKey()) == false)
            return false;
        if (other.getValue() == null ^ this.getValue() == null)
            return false;
        if (other.getValue() != null && other.getValue().equals(this.getValue()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getKey() == null) ? 0 : getKey().hashCode());
        hashCode = prime * hashCode + ((getValue() == null) ? 0 : getValue().hashCode());
        return hashCode;
    }

    @Override
    public ListServiceInstancesFilter clone() {
        try {
            return (ListServiceInstancesFilter) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.proton.model.transform.ListServiceInstancesFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
