/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.proton.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/DeleteEnvironmentTemplate" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DeleteEnvironmentTemplateResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * The detailed data of the environment template being deleted.
     * </p>
     */
    private EnvironmentTemplate environmentTemplate;

    /**
     * <p>
     * The detailed data of the environment template being deleted.
     * </p>
     * 
     * @param environmentTemplate
     *        The detailed data of the environment template being deleted.
     */

    public void setEnvironmentTemplate(EnvironmentTemplate environmentTemplate) {
        this.environmentTemplate = environmentTemplate;
    }

    /**
     * <p>
     * The detailed data of the environment template being deleted.
     * </p>
     * 
     * @return The detailed data of the environment template being deleted.
     */

    public EnvironmentTemplate getEnvironmentTemplate() {
        return this.environmentTemplate;
    }

    /**
     * <p>
     * The detailed data of the environment template being deleted.
     * </p>
     * 
     * @param environmentTemplate
     *        The detailed data of the environment template being deleted.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DeleteEnvironmentTemplateResult withEnvironmentTemplate(EnvironmentTemplate environmentTemplate) {
        setEnvironmentTemplate(environmentTemplate);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getEnvironmentTemplate() != null)
            sb.append("EnvironmentTemplate: ").append(getEnvironmentTemplate());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DeleteEnvironmentTemplateResult == false)
            return false;
        DeleteEnvironmentTemplateResult other = (DeleteEnvironmentTemplateResult) obj;
        if (other.getEnvironmentTemplate() == null ^ this.getEnvironmentTemplate() == null)
            return false;
        if (other.getEnvironmentTemplate() != null && other.getEnvironmentTemplate().equals(this.getEnvironmentTemplate()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getEnvironmentTemplate() == null) ? 0 : getEnvironmentTemplate().hashCode());
        return hashCode;
    }

    @Override
    public DeleteEnvironmentTemplateResult clone() {
        try {
            return (DeleteEnvironmentTemplateResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
