/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.proton.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListEnvironments" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListEnvironmentsRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * An array of the versions of the environment template.
     * </p>
     */
    private java.util.List<EnvironmentTemplateFilter> environmentTemplates;
    /**
     * <p>
     * The maximum number of environments to list.
     * </p>
     */
    private Integer maxResults;
    /**
     * <p>
     * A token that indicates the location of the next environment in the array of environments, after the list of
     * environments that was previously requested.
     * </p>
     */
    private String nextToken;

    /**
     * <p>
     * An array of the versions of the environment template.
     * </p>
     * 
     * @return An array of the versions of the environment template.
     */

    public java.util.List<EnvironmentTemplateFilter> getEnvironmentTemplates() {
        return environmentTemplates;
    }

    /**
     * <p>
     * An array of the versions of the environment template.
     * </p>
     * 
     * @param environmentTemplates
     *        An array of the versions of the environment template.
     */

    public void setEnvironmentTemplates(java.util.Collection<EnvironmentTemplateFilter> environmentTemplates) {
        if (environmentTemplates == null) {
            this.environmentTemplates = null;
            return;
        }

        this.environmentTemplates = new java.util.ArrayList<EnvironmentTemplateFilter>(environmentTemplates);
    }

    /**
     * <p>
     * An array of the versions of the environment template.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setEnvironmentTemplates(java.util.Collection)} or {@link #withEnvironmentTemplates(java.util.Collection)}
     * if you want to override the existing values.
     * </p>
     * 
     * @param environmentTemplates
     *        An array of the versions of the environment template.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListEnvironmentsRequest withEnvironmentTemplates(EnvironmentTemplateFilter... environmentTemplates) {
        if (this.environmentTemplates == null) {
            setEnvironmentTemplates(new java.util.ArrayList<EnvironmentTemplateFilter>(environmentTemplates.length));
        }
        for (EnvironmentTemplateFilter ele : environmentTemplates) {
            this.environmentTemplates.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * An array of the versions of the environment template.
     * </p>
     * 
     * @param environmentTemplates
     *        An array of the versions of the environment template.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListEnvironmentsRequest withEnvironmentTemplates(java.util.Collection<EnvironmentTemplateFilter> environmentTemplates) {
        setEnvironmentTemplates(environmentTemplates);
        return this;
    }

    /**
     * <p>
     * The maximum number of environments to list.
     * </p>
     * 
     * @param maxResults
     *        The maximum number of environments to list.
     */

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    /**
     * <p>
     * The maximum number of environments to list.
     * </p>
     * 
     * @return The maximum number of environments to list.
     */

    public Integer getMaxResults() {
        return this.maxResults;
    }

    /**
     * <p>
     * The maximum number of environments to list.
     * </p>
     * 
     * @param maxResults
     *        The maximum number of environments to list.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListEnvironmentsRequest withMaxResults(Integer maxResults) {
        setMaxResults(maxResults);
        return this;
    }

    /**
     * <p>
     * A token that indicates the location of the next environment in the array of environments, after the list of
     * environments that was previously requested.
     * </p>
     * 
     * @param nextToken
     *        A token that indicates the location of the next environment in the array of environments, after the list
     *        of environments that was previously requested.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * A token that indicates the location of the next environment in the array of environments, after the list of
     * environments that was previously requested.
     * </p>
     * 
     * @return A token that indicates the location of the next environment in the array of environments, after the list
     *         of environments that was previously requested.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * A token that indicates the location of the next environment in the array of environments, after the list of
     * environments that was previously requested.
     * </p>
     * 
     * @param nextToken
     *        A token that indicates the location of the next environment in the array of environments, after the list
     *        of environments that was previously requested.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListEnvironmentsRequest withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getEnvironmentTemplates() != null)
            sb.append("EnvironmentTemplates: ").append(getEnvironmentTemplates()).append(",");
        if (getMaxResults() != null)
            sb.append("MaxResults: ").append(getMaxResults()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListEnvironmentsRequest == false)
            return false;
        ListEnvironmentsRequest other = (ListEnvironmentsRequest) obj;
        if (other.getEnvironmentTemplates() == null ^ this.getEnvironmentTemplates() == null)
            return false;
        if (other.getEnvironmentTemplates() != null && other.getEnvironmentTemplates().equals(this.getEnvironmentTemplates()) == false)
            return false;
        if (other.getMaxResults() == null ^ this.getMaxResults() == null)
            return false;
        if (other.getMaxResults() != null && other.getMaxResults().equals(this.getMaxResults()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getEnvironmentTemplates() == null) ? 0 : getEnvironmentTemplates().hashCode());
        hashCode = prime * hashCode + ((getMaxResults() == null) ? 0 : getMaxResults().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        return hashCode;
    }

    @Override
    public ListEnvironmentsRequest clone() {
        return (ListEnvironmentsRequest) super.clone();
    }

}
