/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.qapps.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * A card in a Amazon Q App that generates a response based on the Amazon Q Business service.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/QQueryCard" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class QQueryCard implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The unique identifier of the query card.
     * </p>
     */
    private String id;
    /**
     * <p>
     * The title or label of the query card.
     * </p>
     */
    private String title;
    /**
     * <p>
     * Any dependencies or requirements for the query card.
     * </p>
     */
    private java.util.List<String> dependencies;
    /**
     * <p>
     * The type of the card.
     * </p>
     */
    private String type;
    /**
     * <p>
     * The prompt or instructions displayed for the query card.
     * </p>
     */
    private String prompt;
    /**
     * <p>
     * The source or type of output generated by the query card.
     * </p>
     */
    private String outputSource;
    /**
     * <p>
     * The Amazon Q Business filters applied in this query card when resolving data sources
     * </p>
     */
    private AttributeFilter attributeFilter;

    /**
     * <p>
     * The unique identifier of the query card.
     * </p>
     * 
     * @param id
     *        The unique identifier of the query card.
     */

    public void setId(String id) {
        this.id = id;
    }

    /**
     * <p>
     * The unique identifier of the query card.
     * </p>
     * 
     * @return The unique identifier of the query card.
     */

    public String getId() {
        return this.id;
    }

    /**
     * <p>
     * The unique identifier of the query card.
     * </p>
     * 
     * @param id
     *        The unique identifier of the query card.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public QQueryCard withId(String id) {
        setId(id);
        return this;
    }

    /**
     * <p>
     * The title or label of the query card.
     * </p>
     * 
     * @param title
     *        The title or label of the query card.
     */

    public void setTitle(String title) {
        this.title = title;
    }

    /**
     * <p>
     * The title or label of the query card.
     * </p>
     * 
     * @return The title or label of the query card.
     */

    public String getTitle() {
        return this.title;
    }

    /**
     * <p>
     * The title or label of the query card.
     * </p>
     * 
     * @param title
     *        The title or label of the query card.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public QQueryCard withTitle(String title) {
        setTitle(title);
        return this;
    }

    /**
     * <p>
     * Any dependencies or requirements for the query card.
     * </p>
     * 
     * @return Any dependencies or requirements for the query card.
     */

    public java.util.List<String> getDependencies() {
        return dependencies;
    }

    /**
     * <p>
     * Any dependencies or requirements for the query card.
     * </p>
     * 
     * @param dependencies
     *        Any dependencies or requirements for the query card.
     */

    public void setDependencies(java.util.Collection<String> dependencies) {
        if (dependencies == null) {
            this.dependencies = null;
            return;
        }

        this.dependencies = new java.util.ArrayList<String>(dependencies);
    }

    /**
     * <p>
     * Any dependencies or requirements for the query card.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setDependencies(java.util.Collection)} or {@link #withDependencies(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param dependencies
     *        Any dependencies or requirements for the query card.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public QQueryCard withDependencies(String... dependencies) {
        if (this.dependencies == null) {
            setDependencies(new java.util.ArrayList<String>(dependencies.length));
        }
        for (String ele : dependencies) {
            this.dependencies.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * Any dependencies or requirements for the query card.
     * </p>
     * 
     * @param dependencies
     *        Any dependencies or requirements for the query card.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public QQueryCard withDependencies(java.util.Collection<String> dependencies) {
        setDependencies(dependencies);
        return this;
    }

    /**
     * <p>
     * The type of the card.
     * </p>
     * 
     * @param type
     *        The type of the card.
     * @see CardType
     */

    public void setType(String type) {
        this.type = type;
    }

    /**
     * <p>
     * The type of the card.
     * </p>
     * 
     * @return The type of the card.
     * @see CardType
     */

    public String getType() {
        return this.type;
    }

    /**
     * <p>
     * The type of the card.
     * </p>
     * 
     * @param type
     *        The type of the card.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see CardType
     */

    public QQueryCard withType(String type) {
        setType(type);
        return this;
    }

    /**
     * <p>
     * The type of the card.
     * </p>
     * 
     * @param type
     *        The type of the card.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see CardType
     */

    public QQueryCard withType(CardType type) {
        this.type = type.toString();
        return this;
    }

    /**
     * <p>
     * The prompt or instructions displayed for the query card.
     * </p>
     * 
     * @param prompt
     *        The prompt or instructions displayed for the query card.
     */

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    /**
     * <p>
     * The prompt or instructions displayed for the query card.
     * </p>
     * 
     * @return The prompt or instructions displayed for the query card.
     */

    public String getPrompt() {
        return this.prompt;
    }

    /**
     * <p>
     * The prompt or instructions displayed for the query card.
     * </p>
     * 
     * @param prompt
     *        The prompt or instructions displayed for the query card.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public QQueryCard withPrompt(String prompt) {
        setPrompt(prompt);
        return this;
    }

    /**
     * <p>
     * The source or type of output generated by the query card.
     * </p>
     * 
     * @param outputSource
     *        The source or type of output generated by the query card.
     * @see CardOutputSource
     */

    public void setOutputSource(String outputSource) {
        this.outputSource = outputSource;
    }

    /**
     * <p>
     * The source or type of output generated by the query card.
     * </p>
     * 
     * @return The source or type of output generated by the query card.
     * @see CardOutputSource
     */

    public String getOutputSource() {
        return this.outputSource;
    }

    /**
     * <p>
     * The source or type of output generated by the query card.
     * </p>
     * 
     * @param outputSource
     *        The source or type of output generated by the query card.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see CardOutputSource
     */

    public QQueryCard withOutputSource(String outputSource) {
        setOutputSource(outputSource);
        return this;
    }

    /**
     * <p>
     * The source or type of output generated by the query card.
     * </p>
     * 
     * @param outputSource
     *        The source or type of output generated by the query card.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see CardOutputSource
     */

    public QQueryCard withOutputSource(CardOutputSource outputSource) {
        this.outputSource = outputSource.toString();
        return this;
    }

    /**
     * <p>
     * The Amazon Q Business filters applied in this query card when resolving data sources
     * </p>
     * 
     * @param attributeFilter
     *        The Amazon Q Business filters applied in this query card when resolving data sources
     */

    public void setAttributeFilter(AttributeFilter attributeFilter) {
        this.attributeFilter = attributeFilter;
    }

    /**
     * <p>
     * The Amazon Q Business filters applied in this query card when resolving data sources
     * </p>
     * 
     * @return The Amazon Q Business filters applied in this query card when resolving data sources
     */

    public AttributeFilter getAttributeFilter() {
        return this.attributeFilter;
    }

    /**
     * <p>
     * The Amazon Q Business filters applied in this query card when resolving data sources
     * </p>
     * 
     * @param attributeFilter
     *        The Amazon Q Business filters applied in this query card when resolving data sources
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public QQueryCard withAttributeFilter(AttributeFilter attributeFilter) {
        setAttributeFilter(attributeFilter);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getId() != null)
            sb.append("Id: ").append(getId()).append(",");
        if (getTitle() != null)
            sb.append("Title: ").append(getTitle()).append(",");
        if (getDependencies() != null)
            sb.append("Dependencies: ").append(getDependencies()).append(",");
        if (getType() != null)
            sb.append("Type: ").append(getType()).append(",");
        if (getPrompt() != null)
            sb.append("Prompt: ").append(getPrompt()).append(",");
        if (getOutputSource() != null)
            sb.append("OutputSource: ").append(getOutputSource()).append(",");
        if (getAttributeFilter() != null)
            sb.append("AttributeFilter: ").append(getAttributeFilter());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof QQueryCard == false)
            return false;
        QQueryCard other = (QQueryCard) obj;
        if (other.getId() == null ^ this.getId() == null)
            return false;
        if (other.getId() != null && other.getId().equals(this.getId()) == false)
            return false;
        if (other.getTitle() == null ^ this.getTitle() == null)
            return false;
        if (other.getTitle() != null && other.getTitle().equals(this.getTitle()) == false)
            return false;
        if (other.getDependencies() == null ^ this.getDependencies() == null)
            return false;
        if (other.getDependencies() != null && other.getDependencies().equals(this.getDependencies()) == false)
            return false;
        if (other.getType() == null ^ this.getType() == null)
            return false;
        if (other.getType() != null && other.getType().equals(this.getType()) == false)
            return false;
        if (other.getPrompt() == null ^ this.getPrompt() == null)
            return false;
        if (other.getPrompt() != null && other.getPrompt().equals(this.getPrompt()) == false)
            return false;
        if (other.getOutputSource() == null ^ this.getOutputSource() == null)
            return false;
        if (other.getOutputSource() != null && other.getOutputSource().equals(this.getOutputSource()) == false)
            return false;
        if (other.getAttributeFilter() == null ^ this.getAttributeFilter() == null)
            return false;
        if (other.getAttributeFilter() != null && other.getAttributeFilter().equals(this.getAttributeFilter()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getId() == null) ? 0 : getId().hashCode());
        hashCode = prime * hashCode + ((getTitle() == null) ? 0 : getTitle().hashCode());
        hashCode = prime * hashCode + ((getDependencies() == null) ? 0 : getDependencies().hashCode());
        hashCode = prime * hashCode + ((getType() == null) ? 0 : getType().hashCode());
        hashCode = prime * hashCode + ((getPrompt() == null) ? 0 : getPrompt().hashCode());
        hashCode = prime * hashCode + ((getOutputSource() == null) ? 0 : getOutputSource().hashCode());
        hashCode = prime * hashCode + ((getAttributeFilter() == null) ? 0 : getAttributeFilter().hashCode());
        return hashCode;
    }

    @Override
    public QQueryCard clone() {
        try {
            return (QQueryCard) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.qapps.model.transform.QQueryCardMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
