/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.qapps;

import javax.annotation.Generated;

import com.amazonaws.services.qapps.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSQApps}. Convenient method forms pass through to the corresponding overload that
 * takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSQApps implements AWSQApps {

    protected AbstractAWSQApps() {
    }

    @Override
    public AssociateLibraryItemReviewResult associateLibraryItemReview(AssociateLibraryItemReviewRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AssociateQAppWithUserResult associateQAppWithUser(AssociateQAppWithUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateLibraryItemResult createLibraryItem(CreateLibraryItemRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateQAppResult createQApp(CreateQAppRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteLibraryItemResult deleteLibraryItem(DeleteLibraryItemRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteQAppResult deleteQApp(DeleteQAppRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateLibraryItemReviewResult disassociateLibraryItemReview(DisassociateLibraryItemReviewRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateQAppFromUserResult disassociateQAppFromUser(DisassociateQAppFromUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetLibraryItemResult getLibraryItem(GetLibraryItemRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetQAppResult getQApp(GetQAppRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetQAppSessionResult getQAppSession(GetQAppSessionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ImportDocumentResult importDocument(ImportDocumentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListLibraryItemsResult listLibraryItems(ListLibraryItemsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListQAppsResult listQApps(ListQAppsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PredictQAppResult predictQApp(PredictQAppRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartQAppSessionResult startQAppSession(StartQAppSessionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopQAppSessionResult stopQAppSession(StopQAppSessionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateLibraryItemResult updateLibraryItem(UpdateLibraryItemRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateQAppResult updateQApp(UpdateQAppRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateQAppSessionResult updateQAppSession(UpdateQAppSessionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
