/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.qapps;

import javax.annotation.Generated;

import com.amazonaws.services.qapps.model.*;

/**
 * Abstract implementation of {@code AWSQAppsAsync}. Convenient method forms pass through to the corresponding overload
 * that takes a request object and an {@code AsyncHandler}, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSQAppsAsync extends AbstractAWSQApps implements AWSQAppsAsync {

    protected AbstractAWSQAppsAsync() {
    }

    @Override
    public java.util.concurrent.Future<AssociateLibraryItemReviewResult> associateLibraryItemReviewAsync(AssociateLibraryItemReviewRequest request) {

        return associateLibraryItemReviewAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<AssociateLibraryItemReviewResult> associateLibraryItemReviewAsync(AssociateLibraryItemReviewRequest request,
            com.amazonaws.handlers.AsyncHandler<AssociateLibraryItemReviewRequest, AssociateLibraryItemReviewResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<AssociateQAppWithUserResult> associateQAppWithUserAsync(AssociateQAppWithUserRequest request) {

        return associateQAppWithUserAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<AssociateQAppWithUserResult> associateQAppWithUserAsync(AssociateQAppWithUserRequest request,
            com.amazonaws.handlers.AsyncHandler<AssociateQAppWithUserRequest, AssociateQAppWithUserResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateLibraryItemResult> createLibraryItemAsync(CreateLibraryItemRequest request) {

        return createLibraryItemAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateLibraryItemResult> createLibraryItemAsync(CreateLibraryItemRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateLibraryItemRequest, CreateLibraryItemResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateQAppResult> createQAppAsync(CreateQAppRequest request) {

        return createQAppAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateQAppResult> createQAppAsync(CreateQAppRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateQAppRequest, CreateQAppResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteLibraryItemResult> deleteLibraryItemAsync(DeleteLibraryItemRequest request) {

        return deleteLibraryItemAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteLibraryItemResult> deleteLibraryItemAsync(DeleteLibraryItemRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteLibraryItemRequest, DeleteLibraryItemResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteQAppResult> deleteQAppAsync(DeleteQAppRequest request) {

        return deleteQAppAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteQAppResult> deleteQAppAsync(DeleteQAppRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteQAppRequest, DeleteQAppResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DisassociateLibraryItemReviewResult> disassociateLibraryItemReviewAsync(DisassociateLibraryItemReviewRequest request) {

        return disassociateLibraryItemReviewAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DisassociateLibraryItemReviewResult> disassociateLibraryItemReviewAsync(DisassociateLibraryItemReviewRequest request,
            com.amazonaws.handlers.AsyncHandler<DisassociateLibraryItemReviewRequest, DisassociateLibraryItemReviewResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DisassociateQAppFromUserResult> disassociateQAppFromUserAsync(DisassociateQAppFromUserRequest request) {

        return disassociateQAppFromUserAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DisassociateQAppFromUserResult> disassociateQAppFromUserAsync(DisassociateQAppFromUserRequest request,
            com.amazonaws.handlers.AsyncHandler<DisassociateQAppFromUserRequest, DisassociateQAppFromUserResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetLibraryItemResult> getLibraryItemAsync(GetLibraryItemRequest request) {

        return getLibraryItemAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetLibraryItemResult> getLibraryItemAsync(GetLibraryItemRequest request,
            com.amazonaws.handlers.AsyncHandler<GetLibraryItemRequest, GetLibraryItemResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetQAppResult> getQAppAsync(GetQAppRequest request) {

        return getQAppAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetQAppResult> getQAppAsync(GetQAppRequest request,
            com.amazonaws.handlers.AsyncHandler<GetQAppRequest, GetQAppResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetQAppSessionResult> getQAppSessionAsync(GetQAppSessionRequest request) {

        return getQAppSessionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetQAppSessionResult> getQAppSessionAsync(GetQAppSessionRequest request,
            com.amazonaws.handlers.AsyncHandler<GetQAppSessionRequest, GetQAppSessionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ImportDocumentResult> importDocumentAsync(ImportDocumentRequest request) {

        return importDocumentAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ImportDocumentResult> importDocumentAsync(ImportDocumentRequest request,
            com.amazonaws.handlers.AsyncHandler<ImportDocumentRequest, ImportDocumentResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListLibraryItemsResult> listLibraryItemsAsync(ListLibraryItemsRequest request) {

        return listLibraryItemsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListLibraryItemsResult> listLibraryItemsAsync(ListLibraryItemsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListLibraryItemsRequest, ListLibraryItemsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListQAppsResult> listQAppsAsync(ListQAppsRequest request) {

        return listQAppsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListQAppsResult> listQAppsAsync(ListQAppsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListQAppsRequest, ListQAppsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {

        return listTagsForResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<PredictQAppResult> predictQAppAsync(PredictQAppRequest request) {

        return predictQAppAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<PredictQAppResult> predictQAppAsync(PredictQAppRequest request,
            com.amazonaws.handlers.AsyncHandler<PredictQAppRequest, PredictQAppResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<StartQAppSessionResult> startQAppSessionAsync(StartQAppSessionRequest request) {

        return startQAppSessionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<StartQAppSessionResult> startQAppSessionAsync(StartQAppSessionRequest request,
            com.amazonaws.handlers.AsyncHandler<StartQAppSessionRequest, StartQAppSessionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<StopQAppSessionResult> stopQAppSessionAsync(StopQAppSessionRequest request) {

        return stopQAppSessionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<StopQAppSessionResult> stopQAppSessionAsync(StopQAppSessionRequest request,
            com.amazonaws.handlers.AsyncHandler<StopQAppSessionRequest, StopQAppSessionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {

        return tagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {

        return untagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateLibraryItemResult> updateLibraryItemAsync(UpdateLibraryItemRequest request) {

        return updateLibraryItemAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateLibraryItemResult> updateLibraryItemAsync(UpdateLibraryItemRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateLibraryItemRequest, UpdateLibraryItemResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateQAppResult> updateQAppAsync(UpdateQAppRequest request) {

        return updateQAppAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateQAppResult> updateQAppAsync(UpdateQAppRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateQAppRequest, UpdateQAppResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateQAppSessionResult> updateQAppSessionAsync(UpdateQAppSessionRequest request) {

        return updateQAppSessionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateQAppSessionResult> updateQAppSessionAsync(UpdateQAppSessionRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateQAppSessionRequest, UpdateQAppSessionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

}
