/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.qbusiness;

import javax.annotation.Generated;

import com.amazonaws.services.qbusiness.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSQBusiness}. Convenient method forms pass through to the corresponding overload
 * that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSQBusiness implements AWSQBusiness {

    protected AbstractAWSQBusiness() {
    }

    @Override
    public BatchDeleteDocumentResult batchDeleteDocument(BatchDeleteDocumentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchPutDocumentResult batchPutDocument(BatchPutDocumentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ChatSyncResult chatSync(ChatSyncRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateApplicationResult createApplication(CreateApplicationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateIndexResult createIndex(CreateIndexRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreatePluginResult createPlugin(CreatePluginRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateRetrieverResult createRetriever(CreateRetrieverRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateUserResult createUser(CreateUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateWebExperienceResult createWebExperience(CreateWebExperienceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteApplicationResult deleteApplication(DeleteApplicationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteChatControlsConfigurationResult deleteChatControlsConfiguration(DeleteChatControlsConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteConversationResult deleteConversation(DeleteConversationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDataSourceResult deleteDataSource(DeleteDataSourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteGroupResult deleteGroup(DeleteGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteIndexResult deleteIndex(DeleteIndexRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeletePluginResult deletePlugin(DeletePluginRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteRetrieverResult deleteRetriever(DeleteRetrieverRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteUserResult deleteUser(DeleteUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteWebExperienceResult deleteWebExperience(DeleteWebExperienceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetApplicationResult getApplication(GetApplicationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetChatControlsConfigurationResult getChatControlsConfiguration(GetChatControlsConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDataSourceResult getDataSource(GetDataSourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetGroupResult getGroup(GetGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetIndexResult getIndex(GetIndexRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetPluginResult getPlugin(GetPluginRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetRetrieverResult getRetriever(GetRetrieverRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetUserResult getUser(GetUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetWebExperienceResult getWebExperience(GetWebExperienceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListApplicationsResult listApplications(ListApplicationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListConversationsResult listConversations(ListConversationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDataSourceSyncJobsResult listDataSourceSyncJobs(ListDataSourceSyncJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDataSourcesResult listDataSources(ListDataSourcesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDocumentsResult listDocuments(ListDocumentsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListGroupsResult listGroups(ListGroupsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListIndicesResult listIndices(ListIndicesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListMessagesResult listMessages(ListMessagesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPluginsResult listPlugins(ListPluginsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListRetrieversResult listRetrievers(ListRetrieversRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListWebExperiencesResult listWebExperiences(ListWebExperiencesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutFeedbackResult putFeedback(PutFeedbackRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutGroupResult putGroup(PutGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartDataSourceSyncJobResult startDataSourceSyncJob(StartDataSourceSyncJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopDataSourceSyncJobResult stopDataSourceSyncJob(StopDataSourceSyncJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateApplicationResult updateApplication(UpdateApplicationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateChatControlsConfigurationResult updateChatControlsConfiguration(UpdateChatControlsConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDataSourceResult updateDataSource(UpdateDataSourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateIndexResult updateIndex(UpdateIndexRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdatePluginResult updatePlugin(UpdatePluginRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateRetrieverResult updateRetriever(UpdateRetrieverRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateUserResult updateUser(UpdateUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateWebExperienceResult updateWebExperience(UpdateWebExperienceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
