/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.qconnect;

import javax.annotation.Generated;

import com.amazonaws.services.qconnect.model.*;

/**
 * Abstract implementation of {@code AmazonQConnectAsync}. Convenient method forms pass through to the corresponding
 * overload that takes a request object and an {@code AsyncHandler}, which throws an
 * {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonQConnectAsync extends AbstractAmazonQConnect implements AmazonQConnectAsync {

    protected AbstractAmazonQConnectAsync() {
    }

    @Override
    public java.util.concurrent.Future<CreateAssistantResult> createAssistantAsync(CreateAssistantRequest request) {

        return createAssistantAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateAssistantResult> createAssistantAsync(CreateAssistantRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateAssistantRequest, CreateAssistantResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateAssistantAssociationResult> createAssistantAssociationAsync(CreateAssistantAssociationRequest request) {

        return createAssistantAssociationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateAssistantAssociationResult> createAssistantAssociationAsync(CreateAssistantAssociationRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateAssistantAssociationRequest, CreateAssistantAssociationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateContentResult> createContentAsync(CreateContentRequest request) {

        return createContentAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateContentResult> createContentAsync(CreateContentRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateContentRequest, CreateContentResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateKnowledgeBaseResult> createKnowledgeBaseAsync(CreateKnowledgeBaseRequest request) {

        return createKnowledgeBaseAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateKnowledgeBaseResult> createKnowledgeBaseAsync(CreateKnowledgeBaseRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateKnowledgeBaseRequest, CreateKnowledgeBaseResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateQuickResponseResult> createQuickResponseAsync(CreateQuickResponseRequest request) {

        return createQuickResponseAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateQuickResponseResult> createQuickResponseAsync(CreateQuickResponseRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateQuickResponseRequest, CreateQuickResponseResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateSessionResult> createSessionAsync(CreateSessionRequest request) {

        return createSessionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateSessionResult> createSessionAsync(CreateSessionRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateSessionRequest, CreateSessionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteAssistantResult> deleteAssistantAsync(DeleteAssistantRequest request) {

        return deleteAssistantAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteAssistantResult> deleteAssistantAsync(DeleteAssistantRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteAssistantRequest, DeleteAssistantResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteAssistantAssociationResult> deleteAssistantAssociationAsync(DeleteAssistantAssociationRequest request) {

        return deleteAssistantAssociationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteAssistantAssociationResult> deleteAssistantAssociationAsync(DeleteAssistantAssociationRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteAssistantAssociationRequest, DeleteAssistantAssociationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteContentResult> deleteContentAsync(DeleteContentRequest request) {

        return deleteContentAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteContentResult> deleteContentAsync(DeleteContentRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteContentRequest, DeleteContentResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteImportJobResult> deleteImportJobAsync(DeleteImportJobRequest request) {

        return deleteImportJobAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteImportJobResult> deleteImportJobAsync(DeleteImportJobRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteImportJobRequest, DeleteImportJobResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteKnowledgeBaseResult> deleteKnowledgeBaseAsync(DeleteKnowledgeBaseRequest request) {

        return deleteKnowledgeBaseAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteKnowledgeBaseResult> deleteKnowledgeBaseAsync(DeleteKnowledgeBaseRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteKnowledgeBaseRequest, DeleteKnowledgeBaseResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteQuickResponseResult> deleteQuickResponseAsync(DeleteQuickResponseRequest request) {

        return deleteQuickResponseAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteQuickResponseResult> deleteQuickResponseAsync(DeleteQuickResponseRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteQuickResponseRequest, DeleteQuickResponseResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetAssistantResult> getAssistantAsync(GetAssistantRequest request) {

        return getAssistantAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetAssistantResult> getAssistantAsync(GetAssistantRequest request,
            com.amazonaws.handlers.AsyncHandler<GetAssistantRequest, GetAssistantResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetAssistantAssociationResult> getAssistantAssociationAsync(GetAssistantAssociationRequest request) {

        return getAssistantAssociationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetAssistantAssociationResult> getAssistantAssociationAsync(GetAssistantAssociationRequest request,
            com.amazonaws.handlers.AsyncHandler<GetAssistantAssociationRequest, GetAssistantAssociationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetContentResult> getContentAsync(GetContentRequest request) {

        return getContentAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetContentResult> getContentAsync(GetContentRequest request,
            com.amazonaws.handlers.AsyncHandler<GetContentRequest, GetContentResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetContentSummaryResult> getContentSummaryAsync(GetContentSummaryRequest request) {

        return getContentSummaryAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetContentSummaryResult> getContentSummaryAsync(GetContentSummaryRequest request,
            com.amazonaws.handlers.AsyncHandler<GetContentSummaryRequest, GetContentSummaryResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetImportJobResult> getImportJobAsync(GetImportJobRequest request) {

        return getImportJobAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetImportJobResult> getImportJobAsync(GetImportJobRequest request,
            com.amazonaws.handlers.AsyncHandler<GetImportJobRequest, GetImportJobResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetKnowledgeBaseResult> getKnowledgeBaseAsync(GetKnowledgeBaseRequest request) {

        return getKnowledgeBaseAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetKnowledgeBaseResult> getKnowledgeBaseAsync(GetKnowledgeBaseRequest request,
            com.amazonaws.handlers.AsyncHandler<GetKnowledgeBaseRequest, GetKnowledgeBaseResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetQuickResponseResult> getQuickResponseAsync(GetQuickResponseRequest request) {

        return getQuickResponseAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetQuickResponseResult> getQuickResponseAsync(GetQuickResponseRequest request,
            com.amazonaws.handlers.AsyncHandler<GetQuickResponseRequest, GetQuickResponseResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetRecommendationsResult> getRecommendationsAsync(GetRecommendationsRequest request) {

        return getRecommendationsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetRecommendationsResult> getRecommendationsAsync(GetRecommendationsRequest request,
            com.amazonaws.handlers.AsyncHandler<GetRecommendationsRequest, GetRecommendationsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetSessionResult> getSessionAsync(GetSessionRequest request) {

        return getSessionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetSessionResult> getSessionAsync(GetSessionRequest request,
            com.amazonaws.handlers.AsyncHandler<GetSessionRequest, GetSessionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListAssistantAssociationsResult> listAssistantAssociationsAsync(ListAssistantAssociationsRequest request) {

        return listAssistantAssociationsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListAssistantAssociationsResult> listAssistantAssociationsAsync(ListAssistantAssociationsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListAssistantAssociationsRequest, ListAssistantAssociationsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListAssistantsResult> listAssistantsAsync(ListAssistantsRequest request) {

        return listAssistantsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListAssistantsResult> listAssistantsAsync(ListAssistantsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListAssistantsRequest, ListAssistantsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListContentsResult> listContentsAsync(ListContentsRequest request) {

        return listContentsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListContentsResult> listContentsAsync(ListContentsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListContentsRequest, ListContentsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListImportJobsResult> listImportJobsAsync(ListImportJobsRequest request) {

        return listImportJobsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListImportJobsResult> listImportJobsAsync(ListImportJobsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListImportJobsRequest, ListImportJobsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListKnowledgeBasesResult> listKnowledgeBasesAsync(ListKnowledgeBasesRequest request) {

        return listKnowledgeBasesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListKnowledgeBasesResult> listKnowledgeBasesAsync(ListKnowledgeBasesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListKnowledgeBasesRequest, ListKnowledgeBasesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListQuickResponsesResult> listQuickResponsesAsync(ListQuickResponsesRequest request) {

        return listQuickResponsesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListQuickResponsesResult> listQuickResponsesAsync(ListQuickResponsesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListQuickResponsesRequest, ListQuickResponsesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {

        return listTagsForResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<NotifyRecommendationsReceivedResult> notifyRecommendationsReceivedAsync(NotifyRecommendationsReceivedRequest request) {

        return notifyRecommendationsReceivedAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<NotifyRecommendationsReceivedResult> notifyRecommendationsReceivedAsync(NotifyRecommendationsReceivedRequest request,
            com.amazonaws.handlers.AsyncHandler<NotifyRecommendationsReceivedRequest, NotifyRecommendationsReceivedResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<PutFeedbackResult> putFeedbackAsync(PutFeedbackRequest request) {

        return putFeedbackAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<PutFeedbackResult> putFeedbackAsync(PutFeedbackRequest request,
            com.amazonaws.handlers.AsyncHandler<PutFeedbackRequest, PutFeedbackResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<QueryAssistantResult> queryAssistantAsync(QueryAssistantRequest request) {

        return queryAssistantAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<QueryAssistantResult> queryAssistantAsync(QueryAssistantRequest request,
            com.amazonaws.handlers.AsyncHandler<QueryAssistantRequest, QueryAssistantResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<RemoveKnowledgeBaseTemplateUriResult> removeKnowledgeBaseTemplateUriAsync(RemoveKnowledgeBaseTemplateUriRequest request) {

        return removeKnowledgeBaseTemplateUriAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<RemoveKnowledgeBaseTemplateUriResult> removeKnowledgeBaseTemplateUriAsync(RemoveKnowledgeBaseTemplateUriRequest request,
            com.amazonaws.handlers.AsyncHandler<RemoveKnowledgeBaseTemplateUriRequest, RemoveKnowledgeBaseTemplateUriResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<SearchContentResult> searchContentAsync(SearchContentRequest request) {

        return searchContentAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<SearchContentResult> searchContentAsync(SearchContentRequest request,
            com.amazonaws.handlers.AsyncHandler<SearchContentRequest, SearchContentResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<SearchQuickResponsesResult> searchQuickResponsesAsync(SearchQuickResponsesRequest request) {

        return searchQuickResponsesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<SearchQuickResponsesResult> searchQuickResponsesAsync(SearchQuickResponsesRequest request,
            com.amazonaws.handlers.AsyncHandler<SearchQuickResponsesRequest, SearchQuickResponsesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<SearchSessionsResult> searchSessionsAsync(SearchSessionsRequest request) {

        return searchSessionsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<SearchSessionsResult> searchSessionsAsync(SearchSessionsRequest request,
            com.amazonaws.handlers.AsyncHandler<SearchSessionsRequest, SearchSessionsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<StartContentUploadResult> startContentUploadAsync(StartContentUploadRequest request) {

        return startContentUploadAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<StartContentUploadResult> startContentUploadAsync(StartContentUploadRequest request,
            com.amazonaws.handlers.AsyncHandler<StartContentUploadRequest, StartContentUploadResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<StartImportJobResult> startImportJobAsync(StartImportJobRequest request) {

        return startImportJobAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<StartImportJobResult> startImportJobAsync(StartImportJobRequest request,
            com.amazonaws.handlers.AsyncHandler<StartImportJobRequest, StartImportJobResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {

        return tagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {

        return untagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateContentResult> updateContentAsync(UpdateContentRequest request) {

        return updateContentAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateContentResult> updateContentAsync(UpdateContentRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateContentRequest, UpdateContentResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateKnowledgeBaseTemplateUriResult> updateKnowledgeBaseTemplateUriAsync(UpdateKnowledgeBaseTemplateUriRequest request) {

        return updateKnowledgeBaseTemplateUriAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateKnowledgeBaseTemplateUriResult> updateKnowledgeBaseTemplateUriAsync(UpdateKnowledgeBaseTemplateUriRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateKnowledgeBaseTemplateUriRequest, UpdateKnowledgeBaseTemplateUriResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateQuickResponseResult> updateQuickResponseAsync(UpdateQuickResponseRequest request) {

        return updateQuickResponseAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateQuickResponseResult> updateQuickResponseAsync(UpdateQuickResponseRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateQuickResponseRequest, UpdateQuickResponseResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

}
