/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.qconnect.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.qconnect.model.QuickResponseSearchExpression;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class SearchQuickResponsesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private Map<String, String> attributes;
    private String knowledgeBaseId;
    private Integer maxResults;
    private String nextToken;
    private QuickResponseSearchExpression searchExpression;

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public SearchQuickResponsesRequest withAttributes(Map<String, String> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public SearchQuickResponsesRequest addAttributesEntry(String key, String value) {
        if (null == this.attributes) {
            this.attributes = new HashMap<String, String>();
        }
        if (this.attributes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.attributes.put(key, value);
        return this;
    }

    public SearchQuickResponsesRequest clearAttributesEntries() {
        this.attributes = null;
        return this;
    }

    public void setKnowledgeBaseId(String knowledgeBaseId) {
        this.knowledgeBaseId = knowledgeBaseId;
    }

    public String getKnowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public SearchQuickResponsesRequest withKnowledgeBaseId(String knowledgeBaseId) {
        this.setKnowledgeBaseId(knowledgeBaseId);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public SearchQuickResponsesRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public SearchQuickResponsesRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setSearchExpression(QuickResponseSearchExpression searchExpression) {
        this.searchExpression = searchExpression;
    }

    public QuickResponseSearchExpression getSearchExpression() {
        return this.searchExpression;
    }

    public SearchQuickResponsesRequest withSearchExpression(QuickResponseSearchExpression searchExpression) {
        this.setSearchExpression(searchExpression);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAttributes() != null) {
            sb.append("Attributes: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getKnowledgeBaseId() != null) {
            sb.append("KnowledgeBaseId: ").append(this.getKnowledgeBaseId()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getSearchExpression() != null) {
            sb.append("SearchExpression: ").append(this.getSearchExpression());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchQuickResponsesRequest)) {
            return false;
        }
        SearchQuickResponsesRequest other = (SearchQuickResponsesRequest)obj;
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        if (other.getAttributes() != null && !other.getAttributes().equals(this.getAttributes())) {
            return false;
        }
        if (other.getKnowledgeBaseId() == null ^ this.getKnowledgeBaseId() == null) {
            return false;
        }
        if (other.getKnowledgeBaseId() != null && !other.getKnowledgeBaseId().equals(this.getKnowledgeBaseId())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getSearchExpression() == null ^ this.getSearchExpression() == null) {
            return false;
        }
        return other.getSearchExpression() == null || other.getSearchExpression().equals(this.getSearchExpression());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : this.getAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getKnowledgeBaseId() == null ? 0 : this.getKnowledgeBaseId().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getSearchExpression() == null ? 0 : this.getSearchExpression().hashCode());
        return hashCode;
    }

    public SearchQuickResponsesRequest clone() {
        return (SearchQuickResponsesRequest)super.clone();
    }
}

