/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.qldbsession.model.transform;

import com.amazonaws.services.qldbsession.model.ValueHolder;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;
import java.nio.ByteBuffer;

public class ValueHolderJsonUnmarshaller
implements Unmarshaller<ValueHolder, JsonUnmarshallerContext> {
    private static ValueHolderJsonUnmarshaller instance;

    public ValueHolder unmarshall(JsonUnmarshallerContext context) throws Exception {
        ValueHolder valueHolder = new ValueHolder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("IonBinary", targetDepth)) {
                    context.nextToken();
                    valueHolder.setIonBinary((ByteBuffer)context.getUnmarshaller(ByteBuffer.class).unmarshall((Object)context));
                }
                if (context.testExpression("IonText", targetDepth)) {
                    context.nextToken();
                    valueHolder.setIonText((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return valueHolder;
    }

    public static ValueHolderJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ValueHolderJsonUnmarshaller();
        }
        return instance;
    }
}

