/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.qldbsession.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Contains the details of the ended session.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/qldb-session-2019-07-11/EndSessionResult" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class EndSessionResult implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * Contains server-side performance information for the command.
     * </p>
     */
    private TimingInformation timingInformation;

    /**
     * <p>
     * Contains server-side performance information for the command.
     * </p>
     * 
     * @param timingInformation
     *        Contains server-side performance information for the command.
     */

    public void setTimingInformation(TimingInformation timingInformation) {
        this.timingInformation = timingInformation;
    }

    /**
     * <p>
     * Contains server-side performance information for the command.
     * </p>
     * 
     * @return Contains server-side performance information for the command.
     */

    public TimingInformation getTimingInformation() {
        return this.timingInformation;
    }

    /**
     * <p>
     * Contains server-side performance information for the command.
     * </p>
     * 
     * @param timingInformation
     *        Contains server-side performance information for the command.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public EndSessionResult withTimingInformation(TimingInformation timingInformation) {
        setTimingInformation(timingInformation);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getTimingInformation() != null)
            sb.append("TimingInformation: ").append(getTimingInformation());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof EndSessionResult == false)
            return false;
        EndSessionResult other = (EndSessionResult) obj;
        if (other.getTimingInformation() == null ^ this.getTimingInformation() == null)
            return false;
        if (other.getTimingInformation() != null && other.getTimingInformation().equals(this.getTimingInformation()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getTimingInformation() == null) ? 0 : getTimingInformation().hashCode());
        return hashCode;
    }

    @Override
    public EndSessionResult clone() {
        try {
            return (EndSessionResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.qldbsession.model.transform.EndSessionResultMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
