/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.qldbsession.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.qldbsession.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * SendCommandResult JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class SendCommandResultJsonUnmarshaller implements Unmarshaller<SendCommandResult, JsonUnmarshallerContext> {

    public SendCommandResult unmarshall(JsonUnmarshallerContext context) throws Exception {
        SendCommandResult sendCommandResult = new SendCommandResult();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return sendCommandResult;
        }

        boolean knownMember;

        while (true) {
            if (token == null)
                break;

            knownMember = false;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("StartSession", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    sendCommandResult.setStartSession(StartSessionResultJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("StartTransaction", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    sendCommandResult.setStartTransaction(StartTransactionResultJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("EndSession", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    sendCommandResult.setEndSession(EndSessionResultJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("CommitTransaction", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    sendCommandResult.setCommitTransaction(CommitTransactionResultJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("AbortTransaction", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    sendCommandResult.setAbortTransaction(AbortTransactionResultJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("ExecuteStatement", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    sendCommandResult.setExecuteStatement(ExecuteStatementResultJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("FetchPage", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    sendCommandResult.setFetchPage(FetchPageResultJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (token == FIELD_NAME && !knownMember) {
                    context.nextToken();
                    com.amazonaws.transform.UnknownMemberJsonUnmarshaller.getInstance().unmarshall(context);
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return sendCommandResult;
    }

    private static SendCommandResultJsonUnmarshaller instance;

    public static SendCommandResultJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new SendCommandResultJsonUnmarshaller();
        return instance;
    }
}
