/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.transform.ProjectOperationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ProjectOperation
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> projectedColumns;

    public List<String> getProjectedColumns() {
        return this.projectedColumns;
    }

    public void setProjectedColumns(Collection<String> projectedColumns) {
        if (projectedColumns == null) {
            this.projectedColumns = null;
            return;
        }
        this.projectedColumns = new ArrayList<String>(projectedColumns);
    }

    public ProjectOperation withProjectedColumns(String ... projectedColumns) {
        if (this.projectedColumns == null) {
            this.setProjectedColumns(new ArrayList<String>(projectedColumns.length));
        }
        for (String ele : projectedColumns) {
            this.projectedColumns.add(ele);
        }
        return this;
    }

    public ProjectOperation withProjectedColumns(Collection<String> projectedColumns) {
        this.setProjectedColumns(projectedColumns);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getProjectedColumns() != null) {
            sb.append("ProjectedColumns: ").append(this.getProjectedColumns());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectOperation)) {
            return false;
        }
        ProjectOperation other = (ProjectOperation)obj;
        if (other.getProjectedColumns() == null ^ this.getProjectedColumns() == null) {
            return false;
        }
        return other.getProjectedColumns() == null || other.getProjectedColumns().equals(this.getProjectedColumns());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getProjectedColumns() == null ? 0 : this.getProjectedColumns().hashCode());
        return hashCode;
    }

    public ProjectOperation clone() {
        try {
            return (ProjectOperation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProjectOperationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

