/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.quicksight.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * The scope of the cell for conditional formatting.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/PivotTableConditionalFormattingScope"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class PivotTableConditionalFormattingScope implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The role (field, field total, grand total) of the cell for conditional formatting.
     * </p>
     */
    private String role;

    /**
     * <p>
     * The role (field, field total, grand total) of the cell for conditional formatting.
     * </p>
     * 
     * @param role
     *        The role (field, field total, grand total) of the cell for conditional formatting.
     * @see PivotTableConditionalFormattingScopeRole
     */

    public void setRole(String role) {
        this.role = role;
    }

    /**
     * <p>
     * The role (field, field total, grand total) of the cell for conditional formatting.
     * </p>
     * 
     * @return The role (field, field total, grand total) of the cell for conditional formatting.
     * @see PivotTableConditionalFormattingScopeRole
     */

    public String getRole() {
        return this.role;
    }

    /**
     * <p>
     * The role (field, field total, grand total) of the cell for conditional formatting.
     * </p>
     * 
     * @param role
     *        The role (field, field total, grand total) of the cell for conditional formatting.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see PivotTableConditionalFormattingScopeRole
     */

    public PivotTableConditionalFormattingScope withRole(String role) {
        setRole(role);
        return this;
    }

    /**
     * <p>
     * The role (field, field total, grand total) of the cell for conditional formatting.
     * </p>
     * 
     * @param role
     *        The role (field, field total, grand total) of the cell for conditional formatting.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see PivotTableConditionalFormattingScopeRole
     */

    public PivotTableConditionalFormattingScope withRole(PivotTableConditionalFormattingScopeRole role) {
        this.role = role.toString();
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getRole() != null)
            sb.append("Role: ").append(getRole());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof PivotTableConditionalFormattingScope == false)
            return false;
        PivotTableConditionalFormattingScope other = (PivotTableConditionalFormattingScope) obj;
        if (other.getRole() == null ^ this.getRole() == null)
            return false;
        if (other.getRole() != null && other.getRole().equals(this.getRole()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getRole() == null) ? 0 : getRole().hashCode());
        return hashCode;
    }

    @Override
    public PivotTableConditionalFormattingScope clone() {
        try {
            return (PivotTableConditionalFormattingScope) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.quicksight.model.transform.PivotTableConditionalFormattingScopeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
