/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.Analysis;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class AnalysisMarshaller {
    private static final MarshallingInfo<String> ANALYSISID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AnalysisId").build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Arn").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<List> ERRORS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Errors").build();
    private static final MarshallingInfo<List> DATASETARNS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataSetArns").build();
    private static final MarshallingInfo<String> THEMEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ThemeArn").build();
    private static final MarshallingInfo<Date> CREATEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> LASTUPDATEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastUpdatedTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<List> SHEETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Sheets").build();
    private static final MarshallingInfo<StructuredPojo> OPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Options").build();
    private static final AnalysisMarshaller instance = new AnalysisMarshaller();

    public static AnalysisMarshaller getInstance() {
        return instance;
    }

    public void marshall(Analysis analysis, ProtocolMarshaller protocolMarshaller) {
        if (analysis == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)analysis.getAnalysisId(), ANALYSISID_BINDING);
            protocolMarshaller.marshall((Object)analysis.getArn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)analysis.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)analysis.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall(analysis.getErrors(), ERRORS_BINDING);
            protocolMarshaller.marshall(analysis.getDataSetArns(), DATASETARNS_BINDING);
            protocolMarshaller.marshall((Object)analysis.getThemeArn(), THEMEARN_BINDING);
            protocolMarshaller.marshall((Object)analysis.getCreatedTime(), CREATEDTIME_BINDING);
            protocolMarshaller.marshall((Object)analysis.getLastUpdatedTime(), LASTUPDATEDTIME_BINDING);
            protocolMarshaller.marshall(analysis.getSheets(), SHEETS_BINDING);
            protocolMarshaller.marshall((Object)analysis.getOptions(), OPTIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

