/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.RowAlternateColorOptions;
import com.amazonaws.services.quicksight.model.TableCellStyle;
import com.amazonaws.services.quicksight.model.TableOrientation;
import com.amazonaws.services.quicksight.model.transform.TableOptionsMarshaller;
import java.io.Serializable;

public class TableOptions
implements Serializable,
Cloneable,
StructuredPojo {
    private String orientation;
    private TableCellStyle headerStyle;
    private TableCellStyle cellStyle;
    private RowAlternateColorOptions rowAlternateColorOptions;

    public void setOrientation(String orientation) {
        this.orientation = orientation;
    }

    public String getOrientation() {
        return this.orientation;
    }

    public TableOptions withOrientation(String orientation) {
        this.setOrientation(orientation);
        return this;
    }

    public TableOptions withOrientation(TableOrientation orientation) {
        this.orientation = orientation.toString();
        return this;
    }

    public void setHeaderStyle(TableCellStyle headerStyle) {
        this.headerStyle = headerStyle;
    }

    public TableCellStyle getHeaderStyle() {
        return this.headerStyle;
    }

    public TableOptions withHeaderStyle(TableCellStyle headerStyle) {
        this.setHeaderStyle(headerStyle);
        return this;
    }

    public void setCellStyle(TableCellStyle cellStyle) {
        this.cellStyle = cellStyle;
    }

    public TableCellStyle getCellStyle() {
        return this.cellStyle;
    }

    public TableOptions withCellStyle(TableCellStyle cellStyle) {
        this.setCellStyle(cellStyle);
        return this;
    }

    public void setRowAlternateColorOptions(RowAlternateColorOptions rowAlternateColorOptions) {
        this.rowAlternateColorOptions = rowAlternateColorOptions;
    }

    public RowAlternateColorOptions getRowAlternateColorOptions() {
        return this.rowAlternateColorOptions;
    }

    public TableOptions withRowAlternateColorOptions(RowAlternateColorOptions rowAlternateColorOptions) {
        this.setRowAlternateColorOptions(rowAlternateColorOptions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getOrientation() != null) {
            sb.append("Orientation: ").append(this.getOrientation()).append(",");
        }
        if (this.getHeaderStyle() != null) {
            sb.append("HeaderStyle: ").append(this.getHeaderStyle()).append(",");
        }
        if (this.getCellStyle() != null) {
            sb.append("CellStyle: ").append(this.getCellStyle()).append(",");
        }
        if (this.getRowAlternateColorOptions() != null) {
            sb.append("RowAlternateColorOptions: ").append(this.getRowAlternateColorOptions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableOptions)) {
            return false;
        }
        TableOptions other = (TableOptions)obj;
        if (other.getOrientation() == null ^ this.getOrientation() == null) {
            return false;
        }
        if (other.getOrientation() != null && !other.getOrientation().equals(this.getOrientation())) {
            return false;
        }
        if (other.getHeaderStyle() == null ^ this.getHeaderStyle() == null) {
            return false;
        }
        if (other.getHeaderStyle() != null && !other.getHeaderStyle().equals(this.getHeaderStyle())) {
            return false;
        }
        if (other.getCellStyle() == null ^ this.getCellStyle() == null) {
            return false;
        }
        if (other.getCellStyle() != null && !other.getCellStyle().equals(this.getCellStyle())) {
            return false;
        }
        if (other.getRowAlternateColorOptions() == null ^ this.getRowAlternateColorOptions() == null) {
            return false;
        }
        return other.getRowAlternateColorOptions() == null || other.getRowAlternateColorOptions().equals(this.getRowAlternateColorOptions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getOrientation() == null ? 0 : this.getOrientation().hashCode());
        hashCode = 31 * hashCode + (this.getHeaderStyle() == null ? 0 : this.getHeaderStyle().hashCode());
        hashCode = 31 * hashCode + (this.getCellStyle() == null ? 0 : this.getCellStyle().hashCode());
        hashCode = 31 * hashCode + (this.getRowAlternateColorOptions() == null ? 0 : this.getRowAlternateColorOptions().hashCode());
        return hashCode;
    }

    public TableOptions clone() {
        try {
            return (TableOptions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TableOptionsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

