/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.quicksight.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * The configuration of a sankey diagram.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SankeyDiagramChartConfiguration"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class SankeyDiagramChartConfiguration implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The field well configuration of a sankey diagram.
     * </p>
     */
    private SankeyDiagramFieldWells fieldWells;
    /**
     * <p>
     * The sort configuration of a sankey diagram.
     * </p>
     */
    private SankeyDiagramSortConfiguration sortConfiguration;
    /**
     * <p>
     * The data label configuration of a sankey diagram.
     * </p>
     */
    private DataLabelOptions dataLabels;

    /**
     * <p>
     * The field well configuration of a sankey diagram.
     * </p>
     * 
     * @param fieldWells
     *        The field well configuration of a sankey diagram.
     */

    public void setFieldWells(SankeyDiagramFieldWells fieldWells) {
        this.fieldWells = fieldWells;
    }

    /**
     * <p>
     * The field well configuration of a sankey diagram.
     * </p>
     * 
     * @return The field well configuration of a sankey diagram.
     */

    public SankeyDiagramFieldWells getFieldWells() {
        return this.fieldWells;
    }

    /**
     * <p>
     * The field well configuration of a sankey diagram.
     * </p>
     * 
     * @param fieldWells
     *        The field well configuration of a sankey diagram.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SankeyDiagramChartConfiguration withFieldWells(SankeyDiagramFieldWells fieldWells) {
        setFieldWells(fieldWells);
        return this;
    }

    /**
     * <p>
     * The sort configuration of a sankey diagram.
     * </p>
     * 
     * @param sortConfiguration
     *        The sort configuration of a sankey diagram.
     */

    public void setSortConfiguration(SankeyDiagramSortConfiguration sortConfiguration) {
        this.sortConfiguration = sortConfiguration;
    }

    /**
     * <p>
     * The sort configuration of a sankey diagram.
     * </p>
     * 
     * @return The sort configuration of a sankey diagram.
     */

    public SankeyDiagramSortConfiguration getSortConfiguration() {
        return this.sortConfiguration;
    }

    /**
     * <p>
     * The sort configuration of a sankey diagram.
     * </p>
     * 
     * @param sortConfiguration
     *        The sort configuration of a sankey diagram.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SankeyDiagramChartConfiguration withSortConfiguration(SankeyDiagramSortConfiguration sortConfiguration) {
        setSortConfiguration(sortConfiguration);
        return this;
    }

    /**
     * <p>
     * The data label configuration of a sankey diagram.
     * </p>
     * 
     * @param dataLabels
     *        The data label configuration of a sankey diagram.
     */

    public void setDataLabels(DataLabelOptions dataLabels) {
        this.dataLabels = dataLabels;
    }

    /**
     * <p>
     * The data label configuration of a sankey diagram.
     * </p>
     * 
     * @return The data label configuration of a sankey diagram.
     */

    public DataLabelOptions getDataLabels() {
        return this.dataLabels;
    }

    /**
     * <p>
     * The data label configuration of a sankey diagram.
     * </p>
     * 
     * @param dataLabels
     *        The data label configuration of a sankey diagram.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SankeyDiagramChartConfiguration withDataLabels(DataLabelOptions dataLabels) {
        setDataLabels(dataLabels);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getFieldWells() != null)
            sb.append("FieldWells: ").append(getFieldWells()).append(",");
        if (getSortConfiguration() != null)
            sb.append("SortConfiguration: ").append(getSortConfiguration()).append(",");
        if (getDataLabels() != null)
            sb.append("DataLabels: ").append(getDataLabels());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof SankeyDiagramChartConfiguration == false)
            return false;
        SankeyDiagramChartConfiguration other = (SankeyDiagramChartConfiguration) obj;
        if (other.getFieldWells() == null ^ this.getFieldWells() == null)
            return false;
        if (other.getFieldWells() != null && other.getFieldWells().equals(this.getFieldWells()) == false)
            return false;
        if (other.getSortConfiguration() == null ^ this.getSortConfiguration() == null)
            return false;
        if (other.getSortConfiguration() != null && other.getSortConfiguration().equals(this.getSortConfiguration()) == false)
            return false;
        if (other.getDataLabels() == null ^ this.getDataLabels() == null)
            return false;
        if (other.getDataLabels() != null && other.getDataLabels().equals(this.getDataLabels()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getFieldWells() == null) ? 0 : getFieldWells().hashCode());
        hashCode = prime * hashCode + ((getSortConfiguration() == null) ? 0 : getSortConfiguration().hashCode());
        hashCode = prime * hashCode + ((getDataLabels() == null) ? 0 : getDataLabels().hashCode());
        return hashCode;
    }

    @Override
    public SankeyDiagramChartConfiguration clone() {
        try {
            return (SankeyDiagramChartConfiguration) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.quicksight.model.transform.SankeyDiagramChartConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
