/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.GradientStop;
import com.amazonaws.services.quicksight.model.transform.GradientColorMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GradientColor
implements Serializable,
Cloneable,
StructuredPojo {
    private List<GradientStop> stops;

    public List<GradientStop> getStops() {
        return this.stops;
    }

    public void setStops(Collection<GradientStop> stops) {
        if (stops == null) {
            this.stops = null;
            return;
        }
        this.stops = new ArrayList<GradientStop>(stops);
    }

    public GradientColor withStops(GradientStop ... stops) {
        if (this.stops == null) {
            this.setStops(new ArrayList<GradientStop>(stops.length));
        }
        for (GradientStop ele : stops) {
            this.stops.add(ele);
        }
        return this;
    }

    public GradientColor withStops(Collection<GradientStop> stops) {
        this.setStops(stops);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStops() != null) {
            sb.append("Stops: ").append(this.getStops());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GradientColor)) {
            return false;
        }
        GradientColor other = (GradientColor)obj;
        if (other.getStops() == null ^ this.getStops() == null) {
            return false;
        }
        return other.getStops() == null || other.getStops().equals(this.getStops());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStops() == null ? 0 : this.getStops().hashCode());
        return hashCode;
    }

    public GradientColor clone() {
        try {
            return (GradientColor)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GradientColorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

