/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.quicksight;

import javax.annotation.Generated;

import com.amazonaws.services.quicksight.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AmazonQuickSight}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonQuickSight implements AmazonQuickSight {

    protected AbstractAmazonQuickSight() {
    }

    @Override
    public CancelIngestionResult cancelIngestion(CancelIngestionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAccountCustomizationResult createAccountCustomization(CreateAccountCustomizationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAccountSubscriptionResult createAccountSubscription(CreateAccountSubscriptionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAnalysisResult createAnalysis(CreateAnalysisRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDashboardResult createDashboard(CreateDashboardRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDataSetResult createDataSet(CreateDataSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDataSourceResult createDataSource(CreateDataSourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateFolderResult createFolder(CreateFolderRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateFolderMembershipResult createFolderMembership(CreateFolderMembershipRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateGroupResult createGroup(CreateGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateGroupMembershipResult createGroupMembership(CreateGroupMembershipRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateIAMPolicyAssignmentResult createIAMPolicyAssignment(CreateIAMPolicyAssignmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateIngestionResult createIngestion(CreateIngestionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateNamespaceResult createNamespace(CreateNamespaceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateRefreshScheduleResult createRefreshSchedule(CreateRefreshScheduleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateRoleMembershipResult createRoleMembership(CreateRoleMembershipRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateTemplateResult createTemplate(CreateTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateTemplateAliasResult createTemplateAlias(CreateTemplateAliasRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateThemeResult createTheme(CreateThemeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateThemeAliasResult createThemeAlias(CreateThemeAliasRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateTopicResult createTopic(CreateTopicRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateTopicRefreshScheduleResult createTopicRefreshSchedule(CreateTopicRefreshScheduleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateVPCConnectionResult createVPCConnection(CreateVPCConnectionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAccountCustomizationResult deleteAccountCustomization(DeleteAccountCustomizationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAccountSubscriptionResult deleteAccountSubscription(DeleteAccountSubscriptionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAnalysisResult deleteAnalysis(DeleteAnalysisRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDashboardResult deleteDashboard(DeleteDashboardRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDataSetResult deleteDataSet(DeleteDataSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDataSetRefreshPropertiesResult deleteDataSetRefreshProperties(DeleteDataSetRefreshPropertiesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDataSourceResult deleteDataSource(DeleteDataSourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteFolderResult deleteFolder(DeleteFolderRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteFolderMembershipResult deleteFolderMembership(DeleteFolderMembershipRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteGroupResult deleteGroup(DeleteGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteGroupMembershipResult deleteGroupMembership(DeleteGroupMembershipRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteIAMPolicyAssignmentResult deleteIAMPolicyAssignment(DeleteIAMPolicyAssignmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteIdentityPropagationConfigResult deleteIdentityPropagationConfig(DeleteIdentityPropagationConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteNamespaceResult deleteNamespace(DeleteNamespaceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteRefreshScheduleResult deleteRefreshSchedule(DeleteRefreshScheduleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteRoleCustomPermissionResult deleteRoleCustomPermission(DeleteRoleCustomPermissionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteRoleMembershipResult deleteRoleMembership(DeleteRoleMembershipRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteTemplateResult deleteTemplate(DeleteTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteTemplateAliasResult deleteTemplateAlias(DeleteTemplateAliasRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteThemeResult deleteTheme(DeleteThemeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteThemeAliasResult deleteThemeAlias(DeleteThemeAliasRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteTopicResult deleteTopic(DeleteTopicRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteTopicRefreshScheduleResult deleteTopicRefreshSchedule(DeleteTopicRefreshScheduleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteUserResult deleteUser(DeleteUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteUserByPrincipalIdResult deleteUserByPrincipalId(DeleteUserByPrincipalIdRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteVPCConnectionResult deleteVPCConnection(DeleteVPCConnectionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAccountCustomizationResult describeAccountCustomization(DescribeAccountCustomizationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAccountSettingsResult describeAccountSettings(DescribeAccountSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAccountSubscriptionResult describeAccountSubscription(DescribeAccountSubscriptionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAnalysisResult describeAnalysis(DescribeAnalysisRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAnalysisDefinitionResult describeAnalysisDefinition(DescribeAnalysisDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAnalysisPermissionsResult describeAnalysisPermissions(DescribeAnalysisPermissionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAssetBundleExportJobResult describeAssetBundleExportJob(DescribeAssetBundleExportJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAssetBundleImportJobResult describeAssetBundleImportJob(DescribeAssetBundleImportJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeDashboardResult describeDashboard(DescribeDashboardRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeDashboardDefinitionResult describeDashboardDefinition(DescribeDashboardDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeDashboardPermissionsResult describeDashboardPermissions(DescribeDashboardPermissionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeDashboardSnapshotJobResult describeDashboardSnapshotJob(DescribeDashboardSnapshotJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeDashboardSnapshotJobResultResult describeDashboardSnapshotJobResult(DescribeDashboardSnapshotJobResultRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeDataSetResult describeDataSet(DescribeDataSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeDataSetPermissionsResult describeDataSetPermissions(DescribeDataSetPermissionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeDataSetRefreshPropertiesResult describeDataSetRefreshProperties(DescribeDataSetRefreshPropertiesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeDataSourceResult describeDataSource(DescribeDataSourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeDataSourcePermissionsResult describeDataSourcePermissions(DescribeDataSourcePermissionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeFolderResult describeFolder(DescribeFolderRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeFolderPermissionsResult describeFolderPermissions(DescribeFolderPermissionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeFolderResolvedPermissionsResult describeFolderResolvedPermissions(DescribeFolderResolvedPermissionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeGroupResult describeGroup(DescribeGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeGroupMembershipResult describeGroupMembership(DescribeGroupMembershipRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeIAMPolicyAssignmentResult describeIAMPolicyAssignment(DescribeIAMPolicyAssignmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeIngestionResult describeIngestion(DescribeIngestionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeIpRestrictionResult describeIpRestriction(DescribeIpRestrictionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeKeyRegistrationResult describeKeyRegistration(DescribeKeyRegistrationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeNamespaceResult describeNamespace(DescribeNamespaceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeRefreshScheduleResult describeRefreshSchedule(DescribeRefreshScheduleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeRoleCustomPermissionResult describeRoleCustomPermission(DescribeRoleCustomPermissionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeTemplateResult describeTemplate(DescribeTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeTemplateAliasResult describeTemplateAlias(DescribeTemplateAliasRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeTemplateDefinitionResult describeTemplateDefinition(DescribeTemplateDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeTemplatePermissionsResult describeTemplatePermissions(DescribeTemplatePermissionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeThemeResult describeTheme(DescribeThemeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeThemeAliasResult describeThemeAlias(DescribeThemeAliasRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeThemePermissionsResult describeThemePermissions(DescribeThemePermissionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeTopicResult describeTopic(DescribeTopicRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeTopicPermissionsResult describeTopicPermissions(DescribeTopicPermissionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeTopicRefreshResult describeTopicRefresh(DescribeTopicRefreshRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeTopicRefreshScheduleResult describeTopicRefreshSchedule(DescribeTopicRefreshScheduleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeUserResult describeUser(DescribeUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeVPCConnectionResult describeVPCConnection(DescribeVPCConnectionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GenerateEmbedUrlForAnonymousUserResult generateEmbedUrlForAnonymousUser(GenerateEmbedUrlForAnonymousUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GenerateEmbedUrlForRegisteredUserResult generateEmbedUrlForRegisteredUser(GenerateEmbedUrlForRegisteredUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDashboardEmbedUrlResult getDashboardEmbedUrl(GetDashboardEmbedUrlRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSessionEmbedUrlResult getSessionEmbedUrl(GetSessionEmbedUrlRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAnalysesResult listAnalyses(ListAnalysesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAssetBundleExportJobsResult listAssetBundleExportJobs(ListAssetBundleExportJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAssetBundleImportJobsResult listAssetBundleImportJobs(ListAssetBundleImportJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDashboardVersionsResult listDashboardVersions(ListDashboardVersionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDashboardsResult listDashboards(ListDashboardsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDataSetsResult listDataSets(ListDataSetsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDataSourcesResult listDataSources(ListDataSourcesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListFolderMembersResult listFolderMembers(ListFolderMembersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListFoldersResult listFolders(ListFoldersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListGroupMembershipsResult listGroupMemberships(ListGroupMembershipsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListGroupsResult listGroups(ListGroupsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListIAMPolicyAssignmentsResult listIAMPolicyAssignments(ListIAMPolicyAssignmentsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListIAMPolicyAssignmentsForUserResult listIAMPolicyAssignmentsForUser(ListIAMPolicyAssignmentsForUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListIdentityPropagationConfigsResult listIdentityPropagationConfigs(ListIdentityPropagationConfigsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListIngestionsResult listIngestions(ListIngestionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListNamespacesResult listNamespaces(ListNamespacesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListRefreshSchedulesResult listRefreshSchedules(ListRefreshSchedulesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListRoleMembershipsResult listRoleMemberships(ListRoleMembershipsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTemplateAliasesResult listTemplateAliases(ListTemplateAliasesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTemplateVersionsResult listTemplateVersions(ListTemplateVersionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTemplatesResult listTemplates(ListTemplatesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListThemeAliasesResult listThemeAliases(ListThemeAliasesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListThemeVersionsResult listThemeVersions(ListThemeVersionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListThemesResult listThemes(ListThemesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTopicRefreshSchedulesResult listTopicRefreshSchedules(ListTopicRefreshSchedulesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTopicsResult listTopics(ListTopicsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListUserGroupsResult listUserGroups(ListUserGroupsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListUsersResult listUsers(ListUsersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListVPCConnectionsResult listVPCConnections(ListVPCConnectionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutDataSetRefreshPropertiesResult putDataSetRefreshProperties(PutDataSetRefreshPropertiesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RegisterUserResult registerUser(RegisterUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RestoreAnalysisResult restoreAnalysis(RestoreAnalysisRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SearchAnalysesResult searchAnalyses(SearchAnalysesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SearchDashboardsResult searchDashboards(SearchDashboardsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SearchDataSetsResult searchDataSets(SearchDataSetsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SearchDataSourcesResult searchDataSources(SearchDataSourcesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SearchFoldersResult searchFolders(SearchFoldersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SearchGroupsResult searchGroups(SearchGroupsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartAssetBundleExportJobResult startAssetBundleExportJob(StartAssetBundleExportJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartAssetBundleImportJobResult startAssetBundleImportJob(StartAssetBundleImportJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartDashboardSnapshotJobResult startDashboardSnapshotJob(StartDashboardSnapshotJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateAccountCustomizationResult updateAccountCustomization(UpdateAccountCustomizationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateAccountSettingsResult updateAccountSettings(UpdateAccountSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateAnalysisResult updateAnalysis(UpdateAnalysisRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateAnalysisPermissionsResult updateAnalysisPermissions(UpdateAnalysisPermissionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDashboardResult updateDashboard(UpdateDashboardRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDashboardLinksResult updateDashboardLinks(UpdateDashboardLinksRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDashboardPermissionsResult updateDashboardPermissions(UpdateDashboardPermissionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDashboardPublishedVersionResult updateDashboardPublishedVersion(UpdateDashboardPublishedVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDataSetResult updateDataSet(UpdateDataSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDataSetPermissionsResult updateDataSetPermissions(UpdateDataSetPermissionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDataSourceResult updateDataSource(UpdateDataSourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDataSourcePermissionsResult updateDataSourcePermissions(UpdateDataSourcePermissionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateFolderResult updateFolder(UpdateFolderRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateFolderPermissionsResult updateFolderPermissions(UpdateFolderPermissionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateGroupResult updateGroup(UpdateGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateIAMPolicyAssignmentResult updateIAMPolicyAssignment(UpdateIAMPolicyAssignmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateIdentityPropagationConfigResult updateIdentityPropagationConfig(UpdateIdentityPropagationConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateIpRestrictionResult updateIpRestriction(UpdateIpRestrictionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateKeyRegistrationResult updateKeyRegistration(UpdateKeyRegistrationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdatePublicSharingSettingsResult updatePublicSharingSettings(UpdatePublicSharingSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateRefreshScheduleResult updateRefreshSchedule(UpdateRefreshScheduleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateRoleCustomPermissionResult updateRoleCustomPermission(UpdateRoleCustomPermissionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateSPICECapacityConfigurationResult updateSPICECapacityConfiguration(UpdateSPICECapacityConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateTemplateResult updateTemplate(UpdateTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateTemplateAliasResult updateTemplateAlias(UpdateTemplateAliasRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateTemplatePermissionsResult updateTemplatePermissions(UpdateTemplatePermissionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateThemeResult updateTheme(UpdateThemeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateThemeAliasResult updateThemeAlias(UpdateThemeAliasRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateThemePermissionsResult updateThemePermissions(UpdateThemePermissionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateTopicResult updateTopic(UpdateTopicRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateTopicPermissionsResult updateTopicPermissions(UpdateTopicPermissionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateTopicRefreshScheduleResult updateTopicRefreshSchedule(UpdateTopicRefreshScheduleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateUserResult updateUser(UpdateUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateVPCConnectionResult updateVPCConnection(UpdateVPCConnectionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
