/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.TableFieldOption;
import com.amazonaws.services.quicksight.model.TablePinnedFieldOptions;
import com.amazonaws.services.quicksight.model.transform.TableFieldOptionsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TableFieldOptions
implements Serializable,
Cloneable,
StructuredPojo {
    private List<TableFieldOption> selectedFieldOptions;
    private List<String> order;
    private TablePinnedFieldOptions pinnedFieldOptions;

    public List<TableFieldOption> getSelectedFieldOptions() {
        return this.selectedFieldOptions;
    }

    public void setSelectedFieldOptions(Collection<TableFieldOption> selectedFieldOptions) {
        if (selectedFieldOptions == null) {
            this.selectedFieldOptions = null;
            return;
        }
        this.selectedFieldOptions = new ArrayList<TableFieldOption>(selectedFieldOptions);
    }

    public TableFieldOptions withSelectedFieldOptions(TableFieldOption ... selectedFieldOptions) {
        if (this.selectedFieldOptions == null) {
            this.setSelectedFieldOptions(new ArrayList<TableFieldOption>(selectedFieldOptions.length));
        }
        for (TableFieldOption ele : selectedFieldOptions) {
            this.selectedFieldOptions.add(ele);
        }
        return this;
    }

    public TableFieldOptions withSelectedFieldOptions(Collection<TableFieldOption> selectedFieldOptions) {
        this.setSelectedFieldOptions(selectedFieldOptions);
        return this;
    }

    public List<String> getOrder() {
        return this.order;
    }

    public void setOrder(Collection<String> order) {
        if (order == null) {
            this.order = null;
            return;
        }
        this.order = new ArrayList<String>(order);
    }

    public TableFieldOptions withOrder(String ... order) {
        if (this.order == null) {
            this.setOrder(new ArrayList<String>(order.length));
        }
        for (String ele : order) {
            this.order.add(ele);
        }
        return this;
    }

    public TableFieldOptions withOrder(Collection<String> order) {
        this.setOrder(order);
        return this;
    }

    public void setPinnedFieldOptions(TablePinnedFieldOptions pinnedFieldOptions) {
        this.pinnedFieldOptions = pinnedFieldOptions;
    }

    public TablePinnedFieldOptions getPinnedFieldOptions() {
        return this.pinnedFieldOptions;
    }

    public TableFieldOptions withPinnedFieldOptions(TablePinnedFieldOptions pinnedFieldOptions) {
        this.setPinnedFieldOptions(pinnedFieldOptions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSelectedFieldOptions() != null) {
            sb.append("SelectedFieldOptions: ").append(this.getSelectedFieldOptions()).append(",");
        }
        if (this.getOrder() != null) {
            sb.append("Order: ").append(this.getOrder()).append(",");
        }
        if (this.getPinnedFieldOptions() != null) {
            sb.append("PinnedFieldOptions: ").append(this.getPinnedFieldOptions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableFieldOptions)) {
            return false;
        }
        TableFieldOptions other = (TableFieldOptions)obj;
        if (other.getSelectedFieldOptions() == null ^ this.getSelectedFieldOptions() == null) {
            return false;
        }
        if (other.getSelectedFieldOptions() != null && !other.getSelectedFieldOptions().equals(this.getSelectedFieldOptions())) {
            return false;
        }
        if (other.getOrder() == null ^ this.getOrder() == null) {
            return false;
        }
        if (other.getOrder() != null && !other.getOrder().equals(this.getOrder())) {
            return false;
        }
        if (other.getPinnedFieldOptions() == null ^ this.getPinnedFieldOptions() == null) {
            return false;
        }
        return other.getPinnedFieldOptions() == null || other.getPinnedFieldOptions().equals(this.getPinnedFieldOptions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSelectedFieldOptions() == null ? 0 : this.getSelectedFieldOptions().hashCode());
        hashCode = 31 * hashCode + (this.getOrder() == null ? 0 : this.getOrder().hashCode());
        hashCode = 31 * hashCode + (this.getPinnedFieldOptions() == null ? 0 : this.getPinnedFieldOptions().hashCode());
        return hashCode;
    }

    public TableFieldOptions clone() {
        try {
            return (TableFieldOptions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TableFieldOptionsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

