/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.quicksight.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * A <code>TopBottomFilter</code> filters values that are at the top or the bottom.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/TopBottomFilter" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class TopBottomFilter implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
     * </p>
     */
    private String filterId;
    /**
     * <p>
     * The column that the filter is applied to.
     * </p>
     */
    private ColumnIdentifier column;
    /**
     * <p>
     * The number of items to include in the top bottom filter results.
     * </p>
     */
    private Integer limit;
    /**
     * <p>
     * The aggregation and sort configuration of the top bottom filter.
     * </p>
     */
    private java.util.List<AggregationSortConfiguration> aggregationSortConfigurations;
    /**
     * <p>
     * The level of time precision that is used to aggregate <code>DateTime</code> values.
     * </p>
     */
    private String timeGranularity;
    /**
     * <p>
     * The parameter whose value should be used for the filter value.
     * </p>
     */
    private String parameterName;
    /**
     * <p>
     * The default configurations for the associated controls. This applies only for filters that are scoped to multiple
     * sheets.
     * </p>
     */
    private DefaultFilterControlConfiguration defaultFilterControlConfiguration;

    /**
     * <p>
     * An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
     * </p>
     * 
     * @param filterId
     *        An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
     */

    public void setFilterId(String filterId) {
        this.filterId = filterId;
    }

    /**
     * <p>
     * An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
     * </p>
     * 
     * @return An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
     */

    public String getFilterId() {
        return this.filterId;
    }

    /**
     * <p>
     * An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
     * </p>
     * 
     * @param filterId
     *        An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public TopBottomFilter withFilterId(String filterId) {
        setFilterId(filterId);
        return this;
    }

    /**
     * <p>
     * The column that the filter is applied to.
     * </p>
     * 
     * @param column
     *        The column that the filter is applied to.
     */

    public void setColumn(ColumnIdentifier column) {
        this.column = column;
    }

    /**
     * <p>
     * The column that the filter is applied to.
     * </p>
     * 
     * @return The column that the filter is applied to.
     */

    public ColumnIdentifier getColumn() {
        return this.column;
    }

    /**
     * <p>
     * The column that the filter is applied to.
     * </p>
     * 
     * @param column
     *        The column that the filter is applied to.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public TopBottomFilter withColumn(ColumnIdentifier column) {
        setColumn(column);
        return this;
    }

    /**
     * <p>
     * The number of items to include in the top bottom filter results.
     * </p>
     * 
     * @param limit
     *        The number of items to include in the top bottom filter results.
     */

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    /**
     * <p>
     * The number of items to include in the top bottom filter results.
     * </p>
     * 
     * @return The number of items to include in the top bottom filter results.
     */

    public Integer getLimit() {
        return this.limit;
    }

    /**
     * <p>
     * The number of items to include in the top bottom filter results.
     * </p>
     * 
     * @param limit
     *        The number of items to include in the top bottom filter results.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public TopBottomFilter withLimit(Integer limit) {
        setLimit(limit);
        return this;
    }

    /**
     * <p>
     * The aggregation and sort configuration of the top bottom filter.
     * </p>
     * 
     * @return The aggregation and sort configuration of the top bottom filter.
     */

    public java.util.List<AggregationSortConfiguration> getAggregationSortConfigurations() {
        return aggregationSortConfigurations;
    }

    /**
     * <p>
     * The aggregation and sort configuration of the top bottom filter.
     * </p>
     * 
     * @param aggregationSortConfigurations
     *        The aggregation and sort configuration of the top bottom filter.
     */

    public void setAggregationSortConfigurations(java.util.Collection<AggregationSortConfiguration> aggregationSortConfigurations) {
        if (aggregationSortConfigurations == null) {
            this.aggregationSortConfigurations = null;
            return;
        }

        this.aggregationSortConfigurations = new java.util.ArrayList<AggregationSortConfiguration>(aggregationSortConfigurations);
    }

    /**
     * <p>
     * The aggregation and sort configuration of the top bottom filter.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setAggregationSortConfigurations(java.util.Collection)} or
     * {@link #withAggregationSortConfigurations(java.util.Collection)} if you want to override the existing values.
     * </p>
     * 
     * @param aggregationSortConfigurations
     *        The aggregation and sort configuration of the top bottom filter.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public TopBottomFilter withAggregationSortConfigurations(AggregationSortConfiguration... aggregationSortConfigurations) {
        if (this.aggregationSortConfigurations == null) {
            setAggregationSortConfigurations(new java.util.ArrayList<AggregationSortConfiguration>(aggregationSortConfigurations.length));
        }
        for (AggregationSortConfiguration ele : aggregationSortConfigurations) {
            this.aggregationSortConfigurations.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The aggregation and sort configuration of the top bottom filter.
     * </p>
     * 
     * @param aggregationSortConfigurations
     *        The aggregation and sort configuration of the top bottom filter.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public TopBottomFilter withAggregationSortConfigurations(java.util.Collection<AggregationSortConfiguration> aggregationSortConfigurations) {
        setAggregationSortConfigurations(aggregationSortConfigurations);
        return this;
    }

    /**
     * <p>
     * The level of time precision that is used to aggregate <code>DateTime</code> values.
     * </p>
     * 
     * @param timeGranularity
     *        The level of time precision that is used to aggregate <code>DateTime</code> values.
     * @see TimeGranularity
     */

    public void setTimeGranularity(String timeGranularity) {
        this.timeGranularity = timeGranularity;
    }

    /**
     * <p>
     * The level of time precision that is used to aggregate <code>DateTime</code> values.
     * </p>
     * 
     * @return The level of time precision that is used to aggregate <code>DateTime</code> values.
     * @see TimeGranularity
     */

    public String getTimeGranularity() {
        return this.timeGranularity;
    }

    /**
     * <p>
     * The level of time precision that is used to aggregate <code>DateTime</code> values.
     * </p>
     * 
     * @param timeGranularity
     *        The level of time precision that is used to aggregate <code>DateTime</code> values.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see TimeGranularity
     */

    public TopBottomFilter withTimeGranularity(String timeGranularity) {
        setTimeGranularity(timeGranularity);
        return this;
    }

    /**
     * <p>
     * The level of time precision that is used to aggregate <code>DateTime</code> values.
     * </p>
     * 
     * @param timeGranularity
     *        The level of time precision that is used to aggregate <code>DateTime</code> values.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see TimeGranularity
     */

    public TopBottomFilter withTimeGranularity(TimeGranularity timeGranularity) {
        this.timeGranularity = timeGranularity.toString();
        return this;
    }

    /**
     * <p>
     * The parameter whose value should be used for the filter value.
     * </p>
     * 
     * @param parameterName
     *        The parameter whose value should be used for the filter value.
     */

    public void setParameterName(String parameterName) {
        this.parameterName = parameterName;
    }

    /**
     * <p>
     * The parameter whose value should be used for the filter value.
     * </p>
     * 
     * @return The parameter whose value should be used for the filter value.
     */

    public String getParameterName() {
        return this.parameterName;
    }

    /**
     * <p>
     * The parameter whose value should be used for the filter value.
     * </p>
     * 
     * @param parameterName
     *        The parameter whose value should be used for the filter value.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public TopBottomFilter withParameterName(String parameterName) {
        setParameterName(parameterName);
        return this;
    }

    /**
     * <p>
     * The default configurations for the associated controls. This applies only for filters that are scoped to multiple
     * sheets.
     * </p>
     * 
     * @param defaultFilterControlConfiguration
     *        The default configurations for the associated controls. This applies only for filters that are scoped to
     *        multiple sheets.
     */

    public void setDefaultFilterControlConfiguration(DefaultFilterControlConfiguration defaultFilterControlConfiguration) {
        this.defaultFilterControlConfiguration = defaultFilterControlConfiguration;
    }

    /**
     * <p>
     * The default configurations for the associated controls. This applies only for filters that are scoped to multiple
     * sheets.
     * </p>
     * 
     * @return The default configurations for the associated controls. This applies only for filters that are scoped to
     *         multiple sheets.
     */

    public DefaultFilterControlConfiguration getDefaultFilterControlConfiguration() {
        return this.defaultFilterControlConfiguration;
    }

    /**
     * <p>
     * The default configurations for the associated controls. This applies only for filters that are scoped to multiple
     * sheets.
     * </p>
     * 
     * @param defaultFilterControlConfiguration
     *        The default configurations for the associated controls. This applies only for filters that are scoped to
     *        multiple sheets.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public TopBottomFilter withDefaultFilterControlConfiguration(DefaultFilterControlConfiguration defaultFilterControlConfiguration) {
        setDefaultFilterControlConfiguration(defaultFilterControlConfiguration);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getFilterId() != null)
            sb.append("FilterId: ").append(getFilterId()).append(",");
        if (getColumn() != null)
            sb.append("Column: ").append(getColumn()).append(",");
        if (getLimit() != null)
            sb.append("Limit: ").append(getLimit()).append(",");
        if (getAggregationSortConfigurations() != null)
            sb.append("AggregationSortConfigurations: ").append(getAggregationSortConfigurations()).append(",");
        if (getTimeGranularity() != null)
            sb.append("TimeGranularity: ").append(getTimeGranularity()).append(",");
        if (getParameterName() != null)
            sb.append("ParameterName: ").append(getParameterName()).append(",");
        if (getDefaultFilterControlConfiguration() != null)
            sb.append("DefaultFilterControlConfiguration: ").append(getDefaultFilterControlConfiguration());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof TopBottomFilter == false)
            return false;
        TopBottomFilter other = (TopBottomFilter) obj;
        if (other.getFilterId() == null ^ this.getFilterId() == null)
            return false;
        if (other.getFilterId() != null && other.getFilterId().equals(this.getFilterId()) == false)
            return false;
        if (other.getColumn() == null ^ this.getColumn() == null)
            return false;
        if (other.getColumn() != null && other.getColumn().equals(this.getColumn()) == false)
            return false;
        if (other.getLimit() == null ^ this.getLimit() == null)
            return false;
        if (other.getLimit() != null && other.getLimit().equals(this.getLimit()) == false)
            return false;
        if (other.getAggregationSortConfigurations() == null ^ this.getAggregationSortConfigurations() == null)
            return false;
        if (other.getAggregationSortConfigurations() != null
                && other.getAggregationSortConfigurations().equals(this.getAggregationSortConfigurations()) == false)
            return false;
        if (other.getTimeGranularity() == null ^ this.getTimeGranularity() == null)
            return false;
        if (other.getTimeGranularity() != null && other.getTimeGranularity().equals(this.getTimeGranularity()) == false)
            return false;
        if (other.getParameterName() == null ^ this.getParameterName() == null)
            return false;
        if (other.getParameterName() != null && other.getParameterName().equals(this.getParameterName()) == false)
            return false;
        if (other.getDefaultFilterControlConfiguration() == null ^ this.getDefaultFilterControlConfiguration() == null)
            return false;
        if (other.getDefaultFilterControlConfiguration() != null
                && other.getDefaultFilterControlConfiguration().equals(this.getDefaultFilterControlConfiguration()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getFilterId() == null) ? 0 : getFilterId().hashCode());
        hashCode = prime * hashCode + ((getColumn() == null) ? 0 : getColumn().hashCode());
        hashCode = prime * hashCode + ((getLimit() == null) ? 0 : getLimit().hashCode());
        hashCode = prime * hashCode + ((getAggregationSortConfigurations() == null) ? 0 : getAggregationSortConfigurations().hashCode());
        hashCode = prime * hashCode + ((getTimeGranularity() == null) ? 0 : getTimeGranularity().hashCode());
        hashCode = prime * hashCode + ((getParameterName() == null) ? 0 : getParameterName().hashCode());
        hashCode = prime * hashCode + ((getDefaultFilterControlConfiguration() == null) ? 0 : getDefaultFilterControlConfiguration().hashCode());
        return hashCode;
    }

    @Override
    public TopBottomFilter clone() {
        try {
            return (TopBottomFilter) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.quicksight.model.transform.TopBottomFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
