/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.ColumnIdentifier;
import com.amazonaws.services.quicksight.model.DrillDownFilter;
import com.amazonaws.services.quicksight.model.transform.ExplicitHierarchyMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ExplicitHierarchy
implements Serializable,
Cloneable,
StructuredPojo {
    private String hierarchyId;
    private List<ColumnIdentifier> columns;
    private List<DrillDownFilter> drillDownFilters;

    public void setHierarchyId(String hierarchyId) {
        this.hierarchyId = hierarchyId;
    }

    public String getHierarchyId() {
        return this.hierarchyId;
    }

    public ExplicitHierarchy withHierarchyId(String hierarchyId) {
        this.setHierarchyId(hierarchyId);
        return this;
    }

    public List<ColumnIdentifier> getColumns() {
        return this.columns;
    }

    public void setColumns(Collection<ColumnIdentifier> columns) {
        if (columns == null) {
            this.columns = null;
            return;
        }
        this.columns = new ArrayList<ColumnIdentifier>(columns);
    }

    public ExplicitHierarchy withColumns(ColumnIdentifier ... columns) {
        if (this.columns == null) {
            this.setColumns(new ArrayList<ColumnIdentifier>(columns.length));
        }
        for (ColumnIdentifier ele : columns) {
            this.columns.add(ele);
        }
        return this;
    }

    public ExplicitHierarchy withColumns(Collection<ColumnIdentifier> columns) {
        this.setColumns(columns);
        return this;
    }

    public List<DrillDownFilter> getDrillDownFilters() {
        return this.drillDownFilters;
    }

    public void setDrillDownFilters(Collection<DrillDownFilter> drillDownFilters) {
        if (drillDownFilters == null) {
            this.drillDownFilters = null;
            return;
        }
        this.drillDownFilters = new ArrayList<DrillDownFilter>(drillDownFilters);
    }

    public ExplicitHierarchy withDrillDownFilters(DrillDownFilter ... drillDownFilters) {
        if (this.drillDownFilters == null) {
            this.setDrillDownFilters(new ArrayList<DrillDownFilter>(drillDownFilters.length));
        }
        for (DrillDownFilter ele : drillDownFilters) {
            this.drillDownFilters.add(ele);
        }
        return this;
    }

    public ExplicitHierarchy withDrillDownFilters(Collection<DrillDownFilter> drillDownFilters) {
        this.setDrillDownFilters(drillDownFilters);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getHierarchyId() != null) {
            sb.append("HierarchyId: ").append(this.getHierarchyId()).append(",");
        }
        if (this.getColumns() != null) {
            sb.append("Columns: ").append(this.getColumns()).append(",");
        }
        if (this.getDrillDownFilters() != null) {
            sb.append("DrillDownFilters: ").append(this.getDrillDownFilters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExplicitHierarchy)) {
            return false;
        }
        ExplicitHierarchy other = (ExplicitHierarchy)obj;
        if (other.getHierarchyId() == null ^ this.getHierarchyId() == null) {
            return false;
        }
        if (other.getHierarchyId() != null && !other.getHierarchyId().equals(this.getHierarchyId())) {
            return false;
        }
        if (other.getColumns() == null ^ this.getColumns() == null) {
            return false;
        }
        if (other.getColumns() != null && !other.getColumns().equals(this.getColumns())) {
            return false;
        }
        if (other.getDrillDownFilters() == null ^ this.getDrillDownFilters() == null) {
            return false;
        }
        return other.getDrillDownFilters() == null || other.getDrillDownFilters().equals(this.getDrillDownFilters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getHierarchyId() == null ? 0 : this.getHierarchyId().hashCode());
        hashCode = 31 * hashCode + (this.getColumns() == null ? 0 : this.getColumns().hashCode());
        hashCode = 31 * hashCode + (this.getDrillDownFilters() == null ? 0 : this.getDrillDownFilters().hashCode());
        return hashCode;
    }

    public ExplicitHierarchy clone() {
        try {
            return (ExplicitHierarchy)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ExplicitHierarchyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

